package com.valor.vod.common.tools.stat;

import common.base.tools.stat.TimeStatisticsTools;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

/**
 * @author Tom Tang
 * @date 2022/1/14
 * @since 3.0.0
 */
@Aspect
@Component
public class BeanMethodStatisticsAspect {

    @Around("@annotation(annotation)")
    public Object statRuntime(ProceedingJoinPoint pjp, BeanMethodStatistics annotation) throws Throwable {
        String key = annotation.key();
        if (StringUtils.isEmpty(key)) {
            key = getDefaultKey(pjp);
        }

        TimeStatisticsTools.startTimer("srv-" + key);
        Object ret = pjp.proceed();
        TimeStatisticsTools.stopTimer("srv-" + key);

        return ret;
    }

    private String getDefaultKey(ProceedingJoinPoint pjp) {
        Object target = pjp.getTarget();
        String className = target == null ? "" : target.getClass().getSimpleName();
        return className + '.' + pjp.getSignature().getName();
    }
}
