package com.valor.vod.common.tools.type;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;

import java.util.*;

/**
 * Created by Frank.Huang on 2016/5/30.
 */
public class CollectionUtils {
    /**
     * 检查集合是不是null or empty
     *
     * @param collection
     * @return
     */
    public static boolean isNullOrEmpty(final Collection collection) {
        if (collection == null) {
            return true;
        }

        if (collection.isEmpty()) {
            return true;
        }

        return false;
    }

    public static boolean isNullOrEmpty(final Map map) {
        if (map == null) {
            return true;
        }

        if (map.isEmpty()) {
            return true;
        }

        return false;
    }

    public static boolean isNullOrEmpty(final Multimap map) {
        if (map == null) {
            return true;
        }

        if (map.isEmpty()) {
            return true;
        }

        return false;
    }

    public static boolean isContains(final Set set1, final Set set2) {
        if (isNullOrEmpty(set1) || isNullOrEmpty(set2)) {
            return false;
        }

        for (Object e : set1) {
            if (set2.contains(e)) {
                return true;
            }
        }

        return false;
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return map.get(key);
    }

    public static <T> List<T> union(Collection<T> c1, Collection<T> c2) {
        if (isNullOrEmpty(c1) && isNullOrEmpty(c2)) {
            return new ArrayList<>();
        } else if (isNullOrEmpty(c1)) {
            return new ArrayList<>(c2);
        } else if (isNullOrEmpty(c2)) {
            return new ArrayList<>(c1);
        } else {
            ArrayList<T> res = new ArrayList<>(c1.size() + c2.size());
            res.addAll(c1);
            res.addAll(c2);
            return res;
        }
    }
}
