package com.valor.vod.common.tools.type;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;


/**
 * Created by Frank.Huang on 2016/5/26.
 */
public class NumberTools {
    private static final Logger logger = LoggerFactory.getLogger(NumberTools.class);

    public static Integer str2int(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return -1;
        }
        try {
            return Integer.valueOf(value);
        } catch (NumberFormatException e) {
            logger.error("{}", e);
            return -1;
        }
    }

    public static double doublePrecision(double d, int precision) {
        BigDecimal b = new BigDecimal(d);
        return b.setScale(precision, BigDecimal.ROUND_HALF_UP).doubleValue();
    }


    public static Object toNumeric(Class clazz, String value) {
        try {
            if (clazz == Long.class) {
                return Long.parseLong(value);
            }

            if (clazz == Integer.class) {
                return Integer.parseInt(value);
            }

            if (clazz == Float.class) {
                return Float.parseFloat(value);
            }

            if (clazz == Double.class) {
                return Double.parseDouble(value);
            }

            return null;
        } catch (Exception e) {
            logger.error("ToNumeric exception:{}", e);
            return null;
        }
    }


    public static double toDouble(String value) {
        Object v = toNumeric(Double.class, value);
        if (v != null) {
            return (Double) v;
        }
        return 0;
    }

    public static int UnsignedMinus(int i1, int i2) {
        if (i1 >= i2) {
            return i1 - i2;
        } else {
            return 0;
        }
    }

    public static int random(int min, int max) {
        Double d = min + Math.random() * (max - min);
        return d.intValue();
    }

    public static Long nullToZero(Long v) {
        return (v == null ? 0L : v);
    }

    public static Integer nullToZero(Integer v) {
        return (v == null ? 0 : v);
    }

    public static Double nullToZero(Double v) {
        return v == null ? 0.0 : v;
    }
}
