package com.valor.vod.common.web.response;

import com.google.common.base.Joiner;
import com.valor.vod.common.tools.meta.LanguageTools;
import common.base.tools.encrypt.Base62Tools;
import common.config.tools.config.ConfigTools3;

public class ApiErrMsg {

    private static final Long CONST_XOR = 10001311L;

    public static String encodeDid(String did) {
        try {
            long didValue = Long.valueOf(did, 16);
            return Base62Tools.longToBase62(didValue ^ CONST_XOR);
        } catch (Exception e) {
            return "NA";
        }
    }

    public static String decodeDid(String did) {
        long v = Base62Tools.base62ToLong(did);
        return Long.toHexString(v ^ CONST_XOR);
    }


    public static String getApiErrCode(int ret, int err) {
        return Joiner.on(".").join(ret, err);
    }

    public static String getApiErrMsg(int ret, int err) {
        return getApiErrMsg(ret, err, "Internal error, please try again later.");
    }

    public static String getApiErrMsg(int ret, int err, String defaultMsg) {
        return getApiErrMsg(LanguageTools.LANG_EN, ret, err, defaultMsg);
    }

    public static String getApiErrMsg(String lang, int ret, int err, String defaultMsg) {
        String key = Joiner.on(".").join(lang, ret, err);
        return ConfigTools3.getString(key, defaultMsg);
    }


    public static String getApiErrMsg(String did, String lang, int ret, int err, String defaultMsg) {
        return "";
    }
}

