package com.valor.vod.common.web.tools;

import com.google.common.base.Strings;
import com.valor.vod.common.web.request.BaseRequestArgs;
/**
 * @author Bruce Wu
 * @since 2022-10-25
 */
public class ClientTools {

    private static final String PHONE = "phone";

    public static boolean isMobile(BaseRequestArgs args) {
        if (!Strings.isNullOrEmpty(args.getClient()) && PHONE.equals(args.getClient())) {
            return true;
        }
        return false;
    }

    public static boolean isMobile(String client) {
        return !Strings.isNullOrEmpty(client) && PHONE.equals(client);
    }
}
