package com.valor.vod.common.web.tools;

import com.valor.vod.api.common.encrypt.AESUtils;
import com.valor.vod.api.model.constant.response.HttpCode2;
import common.base.tools.exception.ApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by Frank.Huang on 2017/5/16.
 */
public class CryptMsgTools {
    public static final String ARG_AES_KEY = "wqlnDJADUFnNRUn0fj2CXA";
    private static final Logger logger = LoggerFactory.getLogger(ArgTools.class);

    public static String decryptArg(String msg) throws ApiException {
        try {
            return AESUtils.decrypt(msg, ARG_AES_KEY);
        } catch (Exception e) {
            logger.error("Decode arg exception:{}", e);
            throw new ApiException(HttpCode2.RET_INVALID_PARAM, HttpCode2.ERR_ARG_DECRYPT_EX, "Args decrypt exception.");
        }
    }

    public static String encryptMsg(String msg) {
        try {
            return AESUtils.encrypt(msg, ARG_AES_KEY);
        } catch (Exception e) {
            logger.error("Encrypt arg exception:{}", e);
            return "";
        }
    }

    public static String encryptMsg(byte[] msg) {
        try {
            return AESUtils.encrypt(new String(msg), ARG_AES_KEY);
        } catch (Exception e) {
            logger.error("Encrypt arg exception:{}", e);
            return "";
        }
    }


}
