/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.cache;

import com.google.common.base.Strings;
import com.valor.vod.common.cache.EHCacheHostTools;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.jgroups.JGroupsCacheManagerPeerProviderFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHCacheJGroupsPeerProviderFactory
extends JGroupsCacheManagerPeerProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(EHCacheJGroupsPeerProviderFactory.class);
    private static final String CONNECT = "connect";
    private static final String TAG_BIND_ADDR = "${bind_addr}";
    private static final String TAG_INITIAL_HOSTS = "${initial_hosts}";

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        String connect = this.getProperty(CONNECT, properties);
        if (!Strings.isNullOrEmpty((String)connect)) {
            String initHosts;
            String bindAddr = EHCacheHostTools.getLocalHost();
            if (!Strings.isNullOrEmpty((String)bindAddr)) {
                connect = connect.replace(TAG_BIND_ADDR, bindAddr);
            }
            if (!Strings.isNullOrEmpty((String)(initHosts = EHCacheHostTools.getHosts()))) {
                connect = connect.replace(TAG_INITIAL_HOSTS, initHosts);
            }
            properties.setProperty(CONNECT, connect);
            logger.info("EHCache JGroups connect:[{}]", (Object)connect);
        }
        return super.createCachePeerProvider(cacheManager, properties);
    }

    private String getProperty(String name, Properties properties) {
        String property = PropertyUtil.extractAndLogProperty((String)name, (Properties)properties);
        if (property != null) {
            property = property.trim();
            if ((property = property.replaceAll(" ", "")).equals("")) {
                property = null;
            }
        }
        return property;
    }
}

