/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.logging;

import common.config.tools.config.ConfigTools3;
import common.config.tools.config.ConfigValueTools;
import common.config.tools.config.listener.IConfigChangeListener;
import common.config.tools.configcenter.common.ConfigOverrideTools;
import common.config.tools.model.ConfigChangeListenerDTO;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.context.logging.LoggingApplicationListener;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class VodLoggingApplicationListener
extends LoggingApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private static final Logger logger = LoggerFactory.getLogger(VodLoggingApplicationListener.class);
    public static final String VOD_LOG_CONFIG_NAME = "vod.logging.config.name";
    public static final Map<String, String> DEFAULT_LOG_CONFIG_MAP = new HashMap<String, String>();
    private static final Class<?>[] EVENT_TYPES = new Class[]{ApplicationStartingEvent.class, ApplicationEnvironmentPreparedEvent.class, ApplicationPreparedEvent.class, ContextClosedEvent.class, ApplicationFailedEvent.class, ApplicationStartedEvent.class};
    private static final Class<?>[] SOURCE_TYPES = new Class[]{SpringApplication.class, ApplicationContext.class};

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ApplicationStartedEvent) {
            ApplicationStartedEvent event = (ApplicationStartedEvent)applicationEvent;
            final ConfigurableApplicationContext ctx = event.getApplicationContext();
            try {
                final LoggingSystem logSystem = (LoggingSystem)ctx.getBean("springBootLoggingSystem", LoggingSystem.class);
                final String cfgName = this.getLogConfigName((Environment)ctx.getEnvironment(), logSystem);
                if (StringUtils.isBlank((CharSequence)cfgName)) {
                    return;
                }
                this.loadChange(ctx.getEnvironment(), logSystem, cfgName);
                for (String key : ConfigValueTools.listenerMap.keySet()) {
                    if (!key.contains(cfgName)) continue;
                    int weight = ConfigOverrideTools.getConfigFileWight((String)key);
                    ConfigChangeListenerDTO oldDto = (ConfigChangeListenerDTO)ConfigValueTools.listenerMap.get(key);
                    ConfigChangeListenerDTO newDto = new ConfigChangeListenerDTO(key, weight, null){

                        public IConfigChangeListener getListener() {
                            VodLoggingApplicationListener.this.loadChange(ctx.getEnvironment(), logSystem, cfgName);
                            return super.getListener();
                        }
                    };
                    if (oldDto != null) {
                        newDto.setListener(oldDto.getListener());
                    }
                    ConfigValueTools.listenerMap.put(key, newDto);
                }
            }
            catch (Exception e) {
                logger.error("Initial vod logging listener fail.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChange(ConfigurableEnvironment env, LoggingSystem logSystem, String cfgName) {
        File logConfig;
        LogFile logFile;
        try {
            logFile = LogFile.get((PropertyResolver)env);
            String readCnt = ConfigTools3.getString((String)cfgName);
            if (StringUtils.isBlank((CharSequence)readCnt)) {
                return;
            }
            String ext = FilenameUtils.getExtension((String)cfgName);
            String name = FilenameUtils.getBaseName((String)cfgName);
            logConfig = File.createTempFile(name, "." + ext);
            FileUtils.write((File)logConfig, (CharSequence)readCnt, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.warn("Save tmp file or load bean fail.", (Throwable)e);
            return;
        }
        try {
            logSystem.cleanUp();
            logSystem.initialize(new LoggingInitializationContext(env), logConfig.getAbsolutePath(), logFile);
            this.setLogLevels(logSystem, env);
            logger.info("Change log config success");
        }
        catch (Exception e) {
            logger.error("Change log config fail. Begin recover....", (Throwable)e);
            try {
                this.initialize(env, ClassUtils.getDefaultClassLoader());
                logger.info("Log config recover success.");
            }
            catch (Exception ex) {
                logger.error("Log config recover fail.", (Throwable)ex);
            }
        }
        finally {
            FileUtils.deleteQuietly((File)logConfig);
        }
    }

    private String getLogConfigName(Environment env, LoggingSystem logSystem) {
        String name = env.getProperty(VOD_LOG_CONFIG_NAME);
        if (StringUtils.isBlank((CharSequence)name)) {
            name = DEFAULT_LOG_CONFIG_MAP.get(logSystem.getClass().getName());
        }
        return name;
    }

    private boolean isAssignableFrom(Class<?> type, Class<?> ... supportedTypes) {
        if (type != null) {
            for (Class<?> supportedType : supportedTypes) {
                if (!supportedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return this.isAssignableFrom(sourceType, SOURCE_TYPES);
    }

    public boolean supportsEventType(ResolvableType resolvableType) {
        return this.isAssignableFrom(resolvableType.getRawClass(), EVENT_TYPES);
    }

    static {
        DEFAULT_LOG_CONFIG_MAP.put("org.springframework.boot.logging.log4j2.Log4J2LoggingSystem", "log4j2.xml");
        DEFAULT_LOG_CONFIG_MAP.put("org.springframework.boot.logging.java.JavaLoggingSystem", "logging.properties");
        DEFAULT_LOG_CONFIG_MAP.put("org.springframework.boot.logging.logback.LogbackLoggingSystem", "logback.xml");
    }
}

