/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUTimedCache<K, V> {
    public static final int DEFAULT_MAX_SIZE = 100;
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 600;
    private final Map<K, CachedObject> internal;
    private final long timeoutInMs;

    public LRUTimedCache() {
        this(100, 600);
    }

    public LRUTimedCache(final int maxSize, int defaultTimeout) {
        this.timeoutInMs = defaultTimeout * 1000;
        this.internal = Collections.synchronizedMap(new LinkedHashMap<K, CachedObject>(maxSize + 1, 0.75f, true){
            private static final long serialVersionUID = 4464242524720551192L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, CachedObject> entry) {
                return this.size() > maxSize;
            }
        });
    }

    public V put(K key, V value) {
        CachedObject cached = new CachedObject(value);
        CachedObject previous = this.internal.put(key, cached);
        if (previous == null || previous.isTimedOut(this.timeoutInMs)) {
            return null;
        }
        return previous.value();
    }

    public V get(K key) {
        CachedObject cached = this.internal.get(key);
        if (cached == null) {
            return null;
        }
        if (cached.isTimedOut(this.timeoutInMs)) {
            this.internal.remove(key);
            return null;
        }
        return cached.value();
    }

    private class CachedObject {
        private final V value;
        private final long creationTime;

        CachedObject(V value) {
            this.value = value;
            this.creationTime = System.currentTimeMillis();
        }

        V value() {
            return this.value;
        }

        boolean isTimedOut(long timeout) {
            return this.creationTime + timeout < System.currentTimeMillis();
        }
    }
}

