/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.cloud;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import common.base.tools.type.CollectionUtils;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CloudAudioLanguageUtil {
    public static long languages2Num(List<String> languages) {
        BitSet bitSet = new BitSet();
        languages.forEach(e -> {
            int code = AudioLanguageType.getCodeByName(e);
            if (code >= 1 && code < 64) {
                BitSet languageBitSet = new BitSet();
                languageBitSet.set(code - 1);
                bitSet.or(languageBitSet);
            }
        });
        long[] bits = bitSet.toLongArray();
        return bits.length > 0 ? bits[0] : 0L;
    }

    public static String copatibleLanguage(String language, long appVer) {
        if (appVer < 1090500L && AudioLanguageType.ZH.name.equalsIgnoreCase(language)) {
            return "CN";
        }
        if (appVer < 1090500L && AudioLanguageType.JA.name.equalsIgnoreCase(language)) {
            return "JP";
        }
        if (appVer < 1090500L && AudioLanguageType.KO.name.equalsIgnoreCase(language)) {
            return "KR";
        }
        return language;
    }

    public static List<String> num2Languages(long languageNum, long appVer) {
        LinkedHashSet languages = Sets.newLinkedHashSet();
        if (languageNum >= 0L) {
            BitSet bitSet = BitSet.valueOf(new long[]{languageNum});
            int length = bitSet.length();
            for (int i = 0; i < length; ++i) {
                String language;
                if (!bitSet.get(i) || !StringUtils.isNotEmpty((CharSequence)(language = AudioLanguageType.getNameByCode(i + 1)))) continue;
                languages.add(CloudAudioLanguageUtil.copatibleLanguage(language, appVer));
            }
        }
        if (CollectionUtils.isNullOrEmpty((Collection)languages)) {
            languages.add(AudioLanguageType.EN.name);
        }
        return Lists.newArrayList((Iterable)languages);
    }

    public static enum AudioLanguageType {
        EN("EN", 1),
        ES("ES", 2),
        PT("PT", 3),
        ZH("ZH", 4),
        JA("JA", 5),
        FR("FR", 6),
        KO("KO", 7),
        TH("TH", 8),
        DE("DE", 9),
        IT("IT", 10),
        OTHER("OTHER", 11),
        FI("FI", 12),
        TL("TL", 13),
        AF("AF", 14),
        ZU("ZU", 15);

        private String name;
        private int code;

        private AudioLanguageType(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public static String getNameByCode(int code) {
            for (AudioLanguageType a : AudioLanguageType.values()) {
                if (a.getCode() != code) continue;
                return a.getName();
            }
            return null;
        }

        public static int getCodeByName(String name) {
            for (AudioLanguageType a : AudioLanguageType.values()) {
                if (!StringUtils.isNotEmpty((CharSequence)name) || !a.getName().equals(name)) continue;
                return a.getCode();
            }
            return OTHER.getCode();
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }
    }
}

