/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.sys;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadRunTool {
    private static final Logger logger = LoggerFactory.getLogger(ThreadRunTool.class);

    public static void runThreads(int maxThreads, int waitMS, Runnable runnable) {
        logger.info("ThreadRunTool startTime[{}].", (Object)System.currentTimeMillis());
        ExecutorService executor = Executors.newFixedThreadPool(maxThreads);
        for (int i = 0; i < maxThreads; ++i) {
            executor.execute(runnable);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            try {
                if (waitMS <= 0) {
                    waitMS = 500;
                }
                TimeUnit.MILLISECONDS.sleep(waitMS);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info("ThreadRunTool endTime[{}].", (Object)System.currentTimeMillis());
    }
}

