package com.valor.vod.common.database.model.control;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.valor.vod.common.database.model.AbstractLMI;
import common.base.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/5/31.
 */
@MappedSuperclass
public class PersonChanged extends AbstractLMI {
    @Id
    @GeneratedValue
    @JsonIgnore
    @Column(name = "id", nullable = false)
    protected long id;

    @Column(name = "tmdb_id")
    protected long tmdbId;

    @Column(name = "imdb_id")
    protected String imdbId;

    @Column(name = "language")
    protected String language;

    @Column(name = "status")
    protected int status; // 0 insert, 1 update, 2 delete

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getTmdbId() {
        return tmdbId;
    }

    public void setTmdbId(long tmdbId) {
        this.tmdbId = tmdbId;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(imdbId, language);
    }
}
