package com.valor.vod.common.tools.mrttoken;

import com.google.common.base.Splitter;
import com.valor.vod.api.common.encrypt.AESUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class MRTTokenTools {

    private static final Logger logger = LoggerFactory.getLogger(MRTTokenTools.class);
//    private static Gson gson = new Gson();

    /**
     * encode mrt token
     *
     * @return
     */
    public static String encode(MRTToken mrtToken, String aseKey) {

        try {
            String tokenStr = AESUtils.encrypt2(mrtToken.toString(), aseKey);
            return tokenStr;
        } catch (Exception e) {
            logger.error("MRTTokenTools encode exception:{}", e);
            return "";
        }
    }


    /**
     * decode mrt token
     *
     * @param tokenStr
     * @return
     */
    public static MRTToken decode(String tokenStr, String aseKey) {
        try {
            String jsonStr = AESUtils.decrypt2(tokenStr, aseKey);
            Map<String, String> tokenValues = Splitter.on(MRTToken.TOKEN_SEPARATOR).withKeyValueSeparator(MRTToken.TOKEN_KV_SEPARATOR).split(jsonStr);
            MRTToken mrtToken = new MRTToken();

            tokenValues.forEach((k, v) -> {
                int key = Integer.valueOf(k);
                EMRTTokenField field = EMRTTokenField.valueOf(key);
                if (field != null) {
                    mrtToken.put(field, v);
                } else {
                    logger.warn("MRTTokenTools Unknown field! key={} value={}", k, v);
                }
            });

            return mrtToken;
        } catch (Exception e) {
            logger.error("MRTTokenTools decode exception:{}", e);
            return null;
        }
    }
}
