package com.valor.vod.common.web.request;

import com.google.common.base.Strings;
import com.valor.vod.api.model.common.EResultItem;
import com.valor.vod.api.model.tools.UserPropTools;
import com.valor.vod.api.model.user.EAccountProperty;
import com.valor.vod.common.tools.http.HttpConstant;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.tools.meta.LanguageTools;
import com.valor.vod.common.web.tools.RegionTools;
import com.valor.vod.common.web.tools.ResultItemTools;

import javax.servlet.http.HttpServletRequest;
import java.util.EnumSet;
import java.util.List;

/**
 * File        : Description : Author      : Frank Created     : 2015/9/2
 */
public class BaseRequestArgs extends AbstractRequestArgs implements IRequestBaseArgs {

    String vendor;
    private int debug = 0;
    private long appVer = -1;       //app version
    private String actKey = "";       //activate key
    private String sessionKey = "";       //session key
    private String token = "";       //token
    private String did = "";       //device id
    private long uid = -1;       //user id
    private long accountId = -1;       //account id
    private int accountType = -1;
    private String lang = "en_US";  //language 格式为:en_US的形式
    private String region = "us";     //国家代码
    // 3.0版本适配5188模式
    private String manualRegion;
    private int linked = 0;        //linked标识
    private String appendResult = "";       //append result
    private String language = "en";     //language
    private String excludeResult = "";
    private String clientIp = "";//客户端IP
    private String clientRegion = "";//客户端region
    private long userProps = 0; //用户属性
    private String endUserIp = "";//终端用户Ip
    private String endUserRegion = "";//终端用户区域
    private String deviceId = "";
    private String clientSession;
    //客户端类型，0=app,1=web
    private int clientTypeNeedVerifySession = 0;
    private String appId;
    private String releaseId;
    private String client;
    private String st;
    private Long vendorId = 0L; // 渠道1000100
    private String model = ""; //型号,如B8;B9
    private String brand = "";//品牌
    private String launcherAppId;
    private String protocol;
    //local变量
    private EnumSet<EResultItem> includeSet = null;
    private EnumSet<EResultItem> excludeSet = null;
    private String channel;
    private String channelDeviceType;
    private String vendorCode;
    private String channelId;
    private String cpuId;
    private String sourceId = "";
    private Boolean isScanCode = false;

    private String productCode = "MFC";

    @Override
    public boolean isArgsValid() {
        checkLanguage();

        return super.isArgsValid();
    }

    public boolean isAppReq() {
        return clientTypeNeedVerifySession == 0;
    }

    public int getClientTypeNeedVerifySession() {
        return clientTypeNeedVerifySession;
    }

    public void setClientTypeNeedVerifySession(int clientTypeNeedVerifySession) {
        this.clientTypeNeedVerifySession = clientTypeNeedVerifySession;
    }

    public String getClientSession() {
        return clientSession;
    }

    public void setClientSession(String clientSession) {
        this.clientSession = clientSession;
    }

    public int getAccountType() {
        return accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public String getLanguageRegion() {
        return LanguageTools.getLanguageRegion(lang);
    }

    public boolean checkLanguage() {
        List list = LanguageTools.getLanguageRegionList(lang);
        if (list.size() < 2) {
            argsValid = false;
            setVerifyMsg("language", ArgsVerifyMsg.ARG_INVALID_VALUE);
            return false;
        }

        return true;
    }

    public EnumSet<EResultItem> getAppendResultAsSet() {
        if (includeSet == null) {
            includeSet = ResultItemTools.parseResult(appendResult);
        }

        return includeSet;
    }

    public int getDebug() {
        return debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getSessionKey() {
        return sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    @Override
    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public long getAppVer() {
        return appVer;
    }

    public void setAppVer(long appVer) {
        this.appVer = appVer;
    }

    public String getActKey() {
        return actKey;
    }

    public void setActKey(String actKey) {
        this.actKey = actKey;
    }

    public String getSt() {
        return st;
    }

    public void setSt(String st) {
        this.st = st;
    }

    @Override
    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }


    @Override
    public long getUid() {
        return uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    @Override
    public String getLanguage() {
        if (!Strings.isNullOrEmpty(language)) {
            return LanguageTools.getOrDefaultLanguage(language);
        }

        return LanguageTools.getLanguage(lang);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String getAppendResult() {
        return appendResult;
    }

    public void setAppendResult(String appendResult) {
        this.appendResult = appendResult;
    }

    @Override
    public String getRegion() {
        return region.toLowerCase();
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getManualRegion() {
        return manualRegion;
    }

    public void setManualRegion(String manualRegion) {
        this.manualRegion = manualRegion;
    }

    @Override
    public int getLinked() {
        return linked;
    }

    public void setLinked(int linked) {
        this.linked = linked;
    }

    public void setArgsFromParameter(HttpServletRequest httpRequest) {
        if (httpRequest != null) {
            deviceId = did;
            did = HttpTools.getAttr(httpRequest, HttpConstant.HTTP_REQ_ATTR_DID, deviceId);

            if (uid == -1L) {
                uid = HttpTools.getLongAttr(httpRequest, HttpConstant.HTTP_REQ_ATTR_UID, -1L);
            }

            if (accountId == -1L) {
                accountId = HttpTools.getLongAttr(httpRequest, HttpConstant.HTTP_REQ_ATTR_ACCOUNT_ID, -1L);
            }

            if (accountType == -1) {
                accountType = HttpTools.getIntAttr(httpRequest, HttpConstant.HTTP_ARG_ACCOUNT_TYPE, -1);
            }

            if (Strings.isNullOrEmpty(token)) {
                token = HttpTools.getAttr(httpRequest, HttpConstant.HTTP_REQ_ATTR_TOKEN, "");
            }
            userProps = HttpTools.getLongAttr(httpRequest, HttpConstant.HTTP_REQ_ATTR_UPROP, 0L);

            clientIp = HttpTools.getRemoteHost(httpRequest);
            clientRegion = HttpTools.getClientRegion(httpRequest);
            if (clientSession == null) {
                clientSession = HttpTools.getAttr(httpRequest, HttpConstant.HTTP_ARG_CLIENT_SESSION, "");
            }
        }
    }

    public String getRegion2() {
        return RegionTools.getRegion2(region);
    }

    public String getExcludeResult() {
        return excludeResult;
    }

    public void setExcludeResult(String excludeResult) {
        this.excludeResult = excludeResult;
    }

    public EnumSet<EResultItem> getExcludeResultAsSet() {
        if (excludeSet == null) {
            excludeSet = ResultItemTools.parseResult(excludeResult);
        }

        return excludeSet;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public long getUserProps() {
        return userProps;
    }

    public void setUserProps(long userProps) {
        this.userProps = userProps;
    }

    public boolean isUserLocationIllegal() {
        return UserPropTools.isAccountPropertySet(userProps, EAccountProperty.LOCATION_ILLEGAL);
        //return isUserPropSet(EUserProps.LOCATION_ILLEGAL);
    }

//    public boolean isUserPropSet(EUserProps eup) {
//        return UserPropTools.isPropertySet(userProps, eup);
//    }

    public String getClientRegion() {
        return clientRegion;
    }

    public void setClientRegion(String clientRegion) {
        this.clientRegion = clientRegion;
    }

    public long getAccountId() {
        return accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public String getLang() {
        return lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public EnumSet<EResultItem> getIncludeSet() {
        return includeSet;
    }

    public void setIncludeSet(EnumSet<EResultItem> includeSet) {
        this.includeSet = includeSet;
    }

    public EnumSet<EResultItem> getExcludeSet() {
        return excludeSet;
    }

    public void setExcludeSet(EnumSet<EResultItem> excludeSet) {
        this.excludeSet = excludeSet;
    }

    public String getEndUserIp() {
        return endUserIp;
    }

    public void setEndUserIp(String endUserIp) {
        this.endUserIp = endUserIp;
    }

    public String getEndUserRegion() {
        return endUserRegion;
    }

    public void setEndUserRegion(String endUserRegion) {
        this.endUserRegion = endUserRegion;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getReleaseId() {
        return releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public String getClient() {
        return client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Long getVendorId() {
        return vendorId;
    }

    public void setVendorId(Long vendorId) {
        this.vendorId = vendorId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getLauncherAppId() {
        return launcherAppId;
    }

    public void setLauncherAppId(String launcherAppId) {
        this.launcherAppId = launcherAppId;
    }

    public String getVendor() {
        return vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getChannelDeviceType() {
        return channelDeviceType;
    }

    public void setChannelDeviceType(String channelDeviceType) {
        this.channelDeviceType = channelDeviceType;
    }

    public String getVendorCode() {
        return vendorCode;
    }

    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getCpuId() {
        return cpuId;
    }

    public void setCpuId(String cpuId) {
        this.cpuId = cpuId;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Boolean getIsScanCode() {
        return isScanCode;
    }

    public void setIsScanCode(Boolean scanCode) {
        isScanCode = scanCode;
    }
}
