/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.valor.vod.common.http.resp.AccountBaseInfoResp;
import common.config.tools.config.ConfigTools3;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class UserHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(UserHttpClient.class);
    @Autowired
    private RestTemplate vmsRestTemplate;

    public AccountBaseInfoResp queryAccountBaseInfoByDid(String did) throws Exception {
        return this.queryAccountBaseInfoByLoginId(did, 5, 0);
    }

    public AccountBaseInfoResp queryAccountBaseInfoByLoginId(String loginId, int userType, int appId) throws Exception {
        String url = ConfigTools3.getString((String)"http.user.queryAccountBaseInfoByLoginId");
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        String fullUrl = url + "?loginId=" + loginId + "&userType=" + userType + "&appId=" + appId;
        logger.info("queryAccountBaseInfoByLoginId(),fullUrl:{}", (Object)fullUrl);
        HttpHeaders requestHeaders = new HttpHeaders();
        HashMap params = new HashMap();
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)requestHeaders);
        ResponseEntity postForEntity = null;
        try {
            postForEntity = this.vmsRestTemplate.postForEntity(fullUrl, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e1) {
            logger.error("queryAccountBaseInfoByLoginId(),invoke exception.{}", (Object)e1.getResponseBodyAsString());
            throw e1;
        }
        if (postForEntity == null) {
            logger.error("queryAccountBaseInfoByLoginId(),response is empty");
            throw new Exception("invoke response is empty");
        }
        logger.info("queryAccountBaseInfoByLoginId(),response:{},{}", (Object)postForEntity.getStatusCodeValue(), postForEntity.getBody());
        if (postForEntity.getStatusCodeValue() == 200) {
            JSONObject userJson = JSONObject.parseObject((String)((String)postForEntity.getBody())).getJSONObject("result");
            AccountBaseInfoResp account = (AccountBaseInfoResp)((Object)JSON.toJavaObject((JSON)userJson, AccountBaseInfoResp.class));
            logger.info("queryAccountBaseInfoByLoginId(),return success,accountId:{},accountType:{}", (Object)account.getAccountId(), (Object)account.getAccountType());
            return account;
        }
        if (postForEntity.getStatusCodeValue() == 555) {
            JSONObject userJson = JSONObject.parseObject((String)((String)postForEntity.getBody()));
            int retCode = userJson.getIntValue("retCode");
            int errCode = userJson.getIntValue("errCode");
            if (retCode == 1003 && errCode == 20001) {
                logger.info("queryAccountBaseInfoByLoginId(),return notfound,retCode:{},errCode:{}", (Object)retCode, (Object)errCode);
                return null;
            }
            logger.error("queryAccountBaseInfoByLoginId(),response is {},not 200", (Object)postForEntity.getStatusCodeValue());
            throw new Exception("response is " + postForEntity.getStatusCodeValue());
        }
        logger.error("queryAccountBaseInfoByLoginId(),response is {},not 200", (Object)postForEntity.getStatusCodeValue());
        throw new Exception("response is " + postForEntity.getStatusCodeValue());
    }
}

