/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.distributed;

import com.valor.vod.common.tools.distributed.DistributedLock;
import com.valor.vod.common.tools.distributed.DistributedLockByRedisImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class BaseNonConcurrentByRedisDistributedTask
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(BaseNonConcurrentByRedisDistributedTask.class);
    @Autowired(required=false)
    @Qualifier(value="redisTemplate")
    private RedisTemplate<String, Object> redisTemplate;
    private DistributedLock lock;

    public void afterPropertiesSet() throws Exception {
        this.lock = new DistributedLockByRedisImpl(this.getRedisTemplate(), this.getLockId(), this.getLockExpirationSeconds());
    }

    private RedisTemplate<String, Object> getRedisTemplate() {
        RedisTemplate<String, Object> redisTemplate = this.getRedisTemplateForLock();
        if (redisTemplate != null) {
            return redisTemplate;
        }
        return this.redisTemplate;
    }

    private String getLockId() {
        return "lock_" + this.getTaskId();
    }

    public void run() {
        if (!this.lock.tryLock()) {
            log.info("The task is in progress. quit.");
            return;
        }
        try {
            this.action();
        }
        catch (Throwable e) {
            log.error("An exception occurred in the task.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected String getTaskId() {
        return this.getClass().getName();
    }

    protected abstract int getLockExpirationSeconds();

    protected RedisTemplate<String, Object> getRedisTemplateForLock() {
        return null;
    }

    protected abstract void action();
}

