/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.http;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.tools.type.DateTimeTools;
import common.base.tools.encrypt.Base62Tools;
import common.config.tools.config.ConfigTools3;
import common.web.tools.http.model.response.WebApiBaseResponse;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ErrorMsgBuilder {
    private static final Long CONST_XOR = 10001311L;

    public static String encodeDeviceId(String deviceId) {
        try {
            if (Strings.isNullOrEmpty((String)deviceId)) {
                return "na";
            }
            long didValue = Long.valueOf(deviceId, 16);
            return Base62Tools.longToBase62((long)(didValue ^ CONST_XOR));
        }
        catch (Exception e) {
            return "na";
        }
    }

    public static String decodeDeviceId(String encodeDeviceId) {
        long base62Str = Base62Tools.base62ToLong((String)encodeDeviceId);
        return Long.toHexString(base62Str ^ CONST_XOR);
    }

    public static String encodeTimestamp() {
        try {
            return Base62Tools.longToBase62((long)(System.currentTimeMillis() / 1000L));
        }
        catch (Exception e) {
            return "na";
        }
    }

    public static String decodeTimestamp(String encodeTimestamp) {
        long ts = Base62Tools.base62ToLong((String)encodeTimestamp);
        return DateTimeTools.datetimeToString(new Date(ts * 1000L));
    }

    public static String buildErrMsg(String language, String deviceId, int retCode, int errCode, String defaultMsg) {
        String langCode = Strings.nullToEmpty((String)language).toLowerCase();
        if (!langCode.equalsIgnoreCase("pt") && !langCode.equalsIgnoreCase("es")) {
            langCode = "en";
        }
        String configKey = String.format("%s.%s.%s", langCode, retCode, errCode);
        String configEnKey = String.format("%s.%s.%s", "en", retCode, errCode);
        String errDesc = ConfigTools3.getString((String)configKey);
        if (Strings.isNullOrEmpty((String)errDesc) && !"en".equalsIgnoreCase(langCode)) {
            errDesc = ConfigTools3.getString((String)configEnKey);
        }
        if (Strings.isNullOrEmpty((String)errDesc) && !Strings.isNullOrEmpty((String)defaultMsg)) {
            errDesc = defaultMsg;
        }
        if (Strings.isNullOrEmpty((String)errDesc)) {
            errDesc = "na";
        }
        String errMsg = "";
        errMsg = !Strings.isNullOrEmpty((String)deviceId) ? String.format("%s.%s.%s.%s:%s", ErrorMsgBuilder.encodeDeviceId(deviceId), ErrorMsgBuilder.encodeTimestamp(), retCode, errCode, errDesc) : String.format("%s.%s:%s", retCode, errCode, errDesc);
        return errMsg;
    }

    public static String buildErrMsgNotAppendCode(String language, String deviceId, int retCode, int errCode, String defaultMsg) {
        String langCode = Strings.nullToEmpty((String)language).toLowerCase();
        if (!langCode.equalsIgnoreCase("pt") && !langCode.equalsIgnoreCase("es")) {
            langCode = "en";
        }
        String configKey = String.format("%s.%s.%s", langCode, retCode, errCode);
        String configEnKey = String.format("%s.%s.%s", "en", retCode, errCode);
        String errDesc = ConfigTools3.getString((String)configKey);
        if (Strings.isNullOrEmpty((String)errDesc) && !"en".equalsIgnoreCase(langCode)) {
            errDesc = ConfigTools3.getString((String)configEnKey);
        }
        if (Strings.isNullOrEmpty((String)errDesc) && !Strings.isNullOrEmpty((String)defaultMsg)) {
            errDesc = defaultMsg;
        }
        if (Strings.isNullOrEmpty((String)errDesc)) {
            errDesc = "na";
        }
        String errMsg = !Strings.isNullOrEmpty((String)deviceId) ? String.format("%s.%s:%s", ErrorMsgBuilder.encodeDeviceId(deviceId), ErrorMsgBuilder.encodeTimestamp(), errDesc) : String.format("%s:%s", ErrorMsgBuilder.encodeTimestamp(), errDesc);
        return errMsg;
    }

    public static String buildErrMsgForReturn(String language, String deviceId, int retCode, int errCode, String defaultMsg) {
        String langCode = Strings.nullToEmpty((String)language).toLowerCase();
        if (!langCode.equalsIgnoreCase("pt") && !langCode.equalsIgnoreCase("es")) {
            langCode = "en";
        }
        String errDesc = defaultMsg;
        if (Strings.isNullOrEmpty((String)defaultMsg)) {
            errDesc = "na";
        }
        String errMsg = String.format("%s.%s", langCode, errDesc);
        return errMsg;
    }

    public static Map<String, String> parseErrMsg(String errorMsg) {
        String enErrMsg;
        LinkedHashMap elementMap = Maps.newLinkedHashMap();
        if (Strings.isNullOrEmpty((String)errorMsg)) {
            return elementMap;
        }
        List elementList = Splitter.on((String)".").splitToList((CharSequence)errorMsg);
        if (elementList.isEmpty()) {
            return elementMap;
        }
        String deviceId = "";
        String ts = "";
        int retCode = -1;
        int errCode = -1;
        for (int i = 0; i < elementList.size(); ++i) {
            String value = (String)elementList.get(i);
            if (i == 0) {
                deviceId = ErrorMsgBuilder.decodeDeviceId(value);
            }
            if (i == 1) {
                ts = ErrorMsgBuilder.decodeTimestamp(value);
            }
            if (i == 2) {
                retCode = Integer.parseInt(value);
            }
            if (i != 3) continue;
            errCode = Integer.parseInt(value);
        }
        elementMap.put("Device Id", deviceId);
        elementMap.put("Timestamp", ts);
        elementMap.put("Module", retCode + "");
        elementMap.put("Error No", errCode + "");
        if (retCode > 0 && errCode > 0 && !Strings.isNullOrEmpty((String)(enErrMsg = ConfigTools3.getString((String)String.format("en.%s.%s", retCode, errCode))))) {
            elementMap.put("Error Message", enErrMsg);
        }
        return elementMap;
    }

    public static String dump(String errMsg) {
        Map<String, String> errInfo = ErrorMsgBuilder.parseErrMsg(errMsg);
        StringBuilder sb = new StringBuilder();
        sb.append("\n*******************************\n");
        sb.append(Joiner.on((String)"\n").withKeyValueSeparator(" : ").join(errInfo));
        sb.append("\n*******************************\n");
        return sb.toString();
    }

    public static void setResponse(ResponseStatus response, String language, String did, int retCode, int errCode, String defaultMsg) {
        response.setRetCode(retCode);
        response.setErrCode(errCode);
        response.setMessage(ErrorMsgBuilder.buildErrMsg(language, did, retCode, errCode, defaultMsg));
    }

    public static void setResponse(WebApiBaseResponse response, String language, String did, int retCode, int errCode, String defaultMsg) {
        response.setRetCode(retCode);
        response.setErrCode(errCode);
        response.setMessage(ErrorMsgBuilder.buildErrMsg(language, did, retCode, errCode, defaultMsg));
    }
}

