/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.stat;

import com.valor.vod.common.tools.stat.BeanMethodStatistics;
import common.base.tools.stat.TimeStatisticsTools;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class BeanMethodStatisticsAspect {
    @Around(value="@annotation(annotation)")
    public Object statRuntime(ProceedingJoinPoint pjp, BeanMethodStatistics annotation) throws Throwable {
        String key = annotation.key();
        if (StringUtils.isEmpty((CharSequence)key)) {
            key = this.getDefaultKey(pjp);
        }
        TimeStatisticsTools.startTimer((String)("srv-" + key));
        Object ret = pjp.proceed();
        TimeStatisticsTools.stopTimer((String)("srv-" + key));
        return ret;
    }

    private String getDefaultKey(ProceedingJoinPoint pjp) {
        Object target = pjp.getTarget();
        String className = target == null ? "" : target.getClass().getSimpleName();
        return className + '.' + pjp.getSignature().getName();
    }
}

