/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.valor.vod.common.web.request.CryptRequestArgs;
import com.valor.vod.common.web.request.IArgsValueChecker;
import com.valor.vod.common.web.request.IRequestArgs;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRequestArgs
extends CryptRequestArgs
implements IRequestArgs {
    protected boolean argsValid = true;
    protected Map<String, String> verifyMsg = new HashMap<String, String>();

    @JsonIgnore
    public Map<String, String> getVerifyMsg() {
        return this.verifyMsg;
    }

    public void setVerifyMsg(Map<String, String> verifyMsg) {
        this.verifyMsg = verifyMsg;
    }

    public void setVerifyMsg(String args, String msg) {
        this.verifyMsg.put(args, msg);
    }

    @Override
    @JsonIgnore
    public boolean isArgsValid() {
        return this.argsValid;
    }

    @Override
    @JsonIgnore
    public String getVerifyResult() {
        if (!this.verifyMsg.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            this.verifyMsg.forEach((k, v) -> sb.append(String.format("\"%s\":\"%s\",", k, v)));
            sb.append("}");
            return sb.toString();
        }
        return "";
    }

    @Override
    public boolean checkArgs(String name, Object arg, IArgsValueChecker valueChecker) {
        boolean localArgValid = true;
        if (arg == null) {
            this.setVerifyMsg(name, "Not allowed to be NULL.");
            this.argsValid = false;
            localArgValid = false;
        }
        if (arg instanceof String && ((String)arg).isEmpty()) {
            this.setVerifyMsg(name, "Not allowed to be EMPTY.");
            this.argsValid = false;
            localArgValid = false;
        }
        if (valueChecker != null && !valueChecker.isValueVaild(arg)) {
            this.setVerifyMsg(name, "Invalid VALUE.");
            this.argsValid = false;
            localArgValid = false;
        }
        return localArgValid;
    }

    @Override
    public boolean checkArgs(String name, Object arg) {
        return this.checkArgs(name, arg, null);
    }
}

