/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import com.valor.vod.api.model.common.response.ResponseMsgList;
import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.tools.http.ErrorMsgBuilder;
import com.valor.vod.common.tools.meta.LanguageTools;
import com.valor.vod.common.web.request.IRequestArgs;
import com.valor.vod.common.web.request.PagingArgs;
import com.valor.vod.common.web.response.IResponse;
import com.valor.vod.common.web.response.IResultStatus;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joda.time.DateTime;
import org.springframework.util.CollectionUtils;

public final class ResponseList<T>
extends ResponseMsgList<T>
implements IResponse,
IResultStatus {
    private IRequestArgs requestArgs = null;

    public ResponseList() {
    }

    public ResponseList(List<T> result) {
        this.setResult(result);
    }

    public ResponseList(Integer total, List<T> result) {
        this.setResult(result);
        this.setTotalCount(total);
    }

    @Override
    @JsonIgnore
    public IRequestArgs getRequestArgs() {
        return this.requestArgs;
    }

    @Override
    public void setRequestArgs(IRequestArgs requestArgs) {
        this.requestArgs = requestArgs;
    }

    public void setResult(List<T> result) {
        this.result = result;
        if (!CollectionUtils.isEmpty(result)) {
            this.setCount(result.size());
            if (this.getCount() > this.getTotalCount()) {
                this.setTotalCount(this.getCount());
            }
        } else {
            this.setCount(0);
            this.setTotalCount(0);
        }
        this.setStatusCheck();
    }

    @Override
    public void setStatusCheck() {
        this.setPaging();
        this.setQueryEnd();
        if (this.isSuccess() && CollectionUtils.isEmpty((Collection)this.result)) {
            this.setMessage("No Data Found");
        }
    }

    @Override
    public void setPaging() {
        if (this.requestArgs instanceof PagingArgs) {
            PagingArgs pageArgs = (PagingArgs)this.requestArgs;
            this.pageId = pageArgs.getPageId();
            this.pageSize = pageArgs.getPageSize();
            this.pageNo = this.pageSize > 0 ? (int)Math.ceil((double)this.totalCount / (double)this.pageSize) : -1;
        }
    }

    @Override
    public boolean setAndCheckArgs(IRequestArgs requestArgs) {
        this.requestArgs = requestArgs;
        if (!requestArgs.isArgsValid()) {
            this.setRetCode(3);
            this.setErrCode(250);
            this.setMessage(String.format("Invalid args[%s]", requestArgs.getVerifyResult()));
            return false;
        }
        return true;
    }

    public void setStatusCheck(ResponseStatus status) {
        this.setPaging();
        this.setQueryEnd();
    }

    @Override
    public void setQueryEnd() {
        DateTime duration = DateTime.now().minus(this.serverTimeMS);
        this.queryDuration = duration.getMillis();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    @Override
    public String toStringWithoutContent() {
        return MoreObjects.toStringHelper((Object)this).add("retcode", this.retCode).add("errcode", this.errCode).add("message", (Object)this.message).add("count", this.count).add("totalCount", this.totalCount).add("pageId", this.pageId).add("pageSize", this.pageSize).add("pageNo", this.pageNo).add("queryDuration", this.queryDuration).add("serverTimeMS", this.serverTimeMS).toString();
    }

    @Override
    @JsonIgnore
    public boolean isNullOrEmpty() {
        return this.result == null || this.result.isEmpty();
    }

    @JsonIgnore
    public void setStatus2(int ret, int err) {
        this.setStatus2(LanguageTools.LANG_EN, "", ret, err, "");
    }

    @JsonIgnore
    public void setStatus2(int ret, int err, String defaultMsg) {
        this.setStatus2(LanguageTools.LANG_EN, "", ret, err, defaultMsg);
    }

    @JsonIgnore
    public void setStatus2(String deviceId, int retCode, int errCode, String defaultMsg) {
        this.retCode = retCode;
        this.errCode = errCode;
        this.message = ErrorMsgBuilder.buildErrMsg(LanguageTools.LANG_EN, deviceId, retCode, errCode, defaultMsg);
    }

    @JsonIgnore
    public void setStatus2(String lang, String deviceId, int retCode, int errCode, String defaultMsg) {
        this.retCode = retCode;
        this.errCode = errCode;
        this.message = ErrorMsgBuilder.buildErrMsg(lang, deviceId, retCode, errCode, defaultMsg);
    }
}

