/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import com.valor.vod.api.model.common.response.ResponseMsgSingle;
import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.tools.http.ErrorMsgBuilder;
import com.valor.vod.common.tools.meta.LanguageTools;
import com.valor.vod.common.web.request.IRequestArgs;
import com.valor.vod.common.web.request.PagingArgs;
import com.valor.vod.common.web.response.IResponse;
import com.valor.vod.common.web.response.IResultStatus;
import org.joda.time.DateTime;

public final class ResponseSingle<T>
extends ResponseMsgSingle<T>
implements IResponse,
IResultStatus {
    private IRequestArgs requestArgs = null;

    public ResponseSingle() {
    }

    public ResponseSingle(IRequestArgs requestArgs) {
        this.requestArgs = requestArgs;
    }

    public ResponseSingle(T result) {
        this();
        this.setResult(result);
    }

    public void setResult(T result) {
        if (result == null) {
            this.setCount(0);
        } else {
            this.setCount(1);
            this.setTotalCount(1);
            super.setResult(result);
        }
        this.setStatusCheck();
    }

    @Override
    @JsonIgnore
    public IRequestArgs getRequestArgs() {
        return this.requestArgs;
    }

    @Override
    public void setRequestArgs(IRequestArgs requestArgs) {
        this.requestArgs = requestArgs;
    }

    @Override
    public void setPaging() {
        if (this.requestArgs instanceof PagingArgs) {
            PagingArgs pageArgs = (PagingArgs)this.requestArgs;
            this.pageSize = pageArgs.getPageSize();
            this.pageId = pageArgs.getPageId();
            this.pageNo = this.pageSize != 0 ? (int)Math.ceil((double)this.totalCount * 1.0 / (double)this.pageSize) : 1;
        }
    }

    @Override
    public boolean setAndCheckArgs(IRequestArgs requestArgs) {
        this.requestArgs = requestArgs;
        if (!requestArgs.isArgsValid()) {
            this.setRetCode(3);
            this.setErrCode(250);
            this.setMessage(String.format("Invalid args[%s]", requestArgs.getVerifyResult()));
            return false;
        }
        return true;
    }

    public void setStatusCheck(ResponseStatus status) {
        this.setQueryEnd();
        this.setPaging();
    }

    @Override
    public void setQueryEnd() {
        DateTime duration = DateTime.now().minus(this.serverTimeMS);
        this.queryDuration = duration.getMillis();
    }

    @Override
    public void setStatusCheck() {
        this.setQueryEnd();
        this.setPaging();
        if (this.isSuccess() && this.result == null) {
            this.setMessage("No Data Found");
        }
    }

    @Override
    public String toStringWithoutContent() {
        return MoreObjects.toStringHelper((Object)this).add("retcode", this.retCode).add("errcode", this.errCode).add("message", (Object)this.message).add("count", this.count).add("totalCount", this.totalCount).add("pageId", this.pageId).add("pageSize", this.pageSize).add("pageNo", this.pageNo).add("queryDuration", this.queryDuration).add("serverTimeMS", this.serverTimeMS).toString();
    }

    @Override
    @JsonIgnore
    public boolean isNullOrEmpty() {
        return this.result == null;
    }

    @JsonIgnore
    public void setStatus2(int ret, int err) {
        this.setStatus2(LanguageTools.LANG_EN, "", ret, err, "");
    }

    @JsonIgnore
    public void setStatus2(int ret, int err, String defaultMsg) {
        this.setStatus2(LanguageTools.LANG_EN, "", ret, err, defaultMsg);
    }

    @JsonIgnore
    public void setStatus2(String deviceId, int retCode, int errCode) {
        this.setStatus2(deviceId, retCode, errCode, "");
    }

    @JsonIgnore
    public void setStatus2(String deviceId, int retCode, int errCode, String defaultMsg) {
        this.retCode = retCode;
        this.errCode = errCode;
        this.message = ErrorMsgBuilder.buildErrMsg(LanguageTools.LANG_EN, deviceId, retCode, errCode, defaultMsg);
    }

    @JsonIgnore
    public void setStatus2(String lang, String deviceId, int retCode, int errCode, String defaultMsg) {
        this.retCode = retCode;
        this.errCode = errCode;
        this.message = ErrorMsgBuilder.buildErrMsg(lang, deviceId, retCode, errCode, defaultMsg);
    }

    @JsonIgnore
    public void setReturnStatus2(String lang, String deviceId, int retCode, int errCode, String defaultMsg) {
        this.retCode = retCode;
        this.errCode = errCode;
        this.message = ErrorMsgBuilder.buildErrMsgForReturn(lang, deviceId, retCode, errCode, defaultMsg);
    }
}

