package com.valor.vod.common.constant;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * @author Bruce Wu
 * @date 2023-03-15
 */
public abstract class ConstantPool<T> {

    /** constants */
    private final ConcurrentMap<String, T> constants = new ConcurrentHashMap<>();

    public T valueOf(String name) {
        return getOrCreate(name);
    }

    public T getOrCreate(String name) {
        T constant = constants.get(name);
        if (constant == null) {
            T tempConstant = newConstant(name);
            constant = constants.putIfAbsent(name, tempConstant);
            if (constant == null) {
                return tempConstant;
            }
        }
        return constant;
    }

    /**
     * 创建新的constant
     *
     * @param name
     * @return
     */
    protected abstract T newConstant(String name);
}
