package com.valor.vod.common.database.model;

/**
 * @author Hunter Chen
 * created on: 2018-08-28
 * <p>
 * Wrapper class for db table sharding rules
 */
public class TableShardingParams {
    private final String tableName;
    private final String actualDataNodesExpression;
    private final String shardingColumn;
    private final String strategyExpression;

    /**
     * @param tableName                 the name of the logic table to be sharded, eg, linked_user_cloud
     * @param actualDataNodesExpression An expression for actual tables in the database as a result of sharding
     *                                  For example, to shard a table called 'linked_user_cloud' in a database called ds into ten pieces, we normally name the divided
     *                                  table as linked_user_cloud_0, linked_user_cloud_1, ..., linked_user_cloud_9
     *                                  To achieve this, we assign the value as following. The ${0..9} is a form of expression from Groovy. ds here is whatever name of your database is
     *                                  eg, ds.linked_user_cloud_${0..9}
     * @param shardingColumn            column to be sharded, eg, user_id
     * @param strategyExpression        which table to assign the data to
     *                                  eg,
     *                                  linked_user_cloud_${user_id % 11}
     *                                  it means to mod user_id to 11, and find the actual table according to the name. The number of possible results should match the actualDataNodesExpression
     *                                  defined above
     */
    public TableShardingParams(String tableName, String actualDataNodesExpression, String shardingColumn, String strategyExpression) {
        this.tableName = tableName;
        this.actualDataNodesExpression = actualDataNodesExpression;
        this.shardingColumn = shardingColumn;
        this.strategyExpression = strategyExpression;
    }


    public String getTableName() {
        return tableName;
    }

    public String getActualDataNodesExpression() {
        return actualDataNodesExpression;
    }

    public String getShardingColumn() {
        return shardingColumn;
    }

    public String getStrategyExpression() {
        return strategyExpression;
    }

}
