package com.valor.vod.common.database.model.control;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * @author Frank.Huang
 * @since 2016/5/5
 */
@MappedSuperclass
public class MetaChanged extends AbstractLMI {
    @Id
    @GeneratedValue
    @JsonIgnore
    @Column(name = "id", nullable = false)
    protected long id;

    @Column(name = "tmdb_id")
    protected long tmdbId;

    @Column(name = "imdb_id", nullable = false)
    protected String imdbId;

    @Column(name = "type")
    protected String mediaType; // movie, tv

    @Column(name = "language")
    protected String language;

    @Column(name = "field")
    protected String field = "";

    @Column(name = "status")
    protected int status; // 0 insert, 1 update, 2 delete

    public long getTmdbId() {
        return tmdbId;
    }

    public void setTmdbId(long tmdbId) {
        this.tmdbId = tmdbId;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public String getMediaType() {
        return mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public String valueKey() {
        return com.valor.vod.common.tools.type.DdoKeyTools.key(imdbId, language, field);
    }
}
