package com.valor.vod.common.database.tool.CriteriaWrapper;

import com.google.common.collect.Lists;
import com.valor.vod.common.tools.type.CollectionUtils;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

import java.util.List;
import java.util.Set;

/** Created by Frank.Huang on 2016/8/20. */
public class CriteriaWrapper {
    private CriteriaTools criteriaTools = CriteriaTools.create();
    private Session session = null;
    private Class clazz = null;

    private int firstResult = -1;
    private int maxResult = -1;
    private boolean cacheable = false;
    private boolean readOnly = false;

    public static CriteriaWrapper create(Session session, Class clazz) {
        CriteriaWrapper instance = new CriteriaWrapper();
        instance.session = session;
        instance.clazz = clazz;
        return instance;
    }

    public CriteriaWrapper add(Criterion criterion) {
        criteriaTools.add(criterion);
        return this;
    }

    public CriteriaWrapper add(Set<Criterion> criterions) {
        if (!CollectionUtils.isNullOrEmpty(criterions)) {
            criterions.forEach(e -> criteriaTools.add(e));
        }
        return this;
    }

    public CriteriaWrapper addOrder(Order order) {
        criteriaTools.addOrder(order);
        return this;
    }

    public CriteriaWrapper addOrder(Set<Order> orders) {
        if (!CollectionUtils.isNullOrEmpty(orders)) {
            orders.forEach(e -> criteriaTools.addOrder(e));
        }
        return this;
    }

    public CriteriaWrapper setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public CriteriaWrapper setMaxResult(int maxResult) {
        this.maxResult = maxResult;
        return this;
    }

    public CriteriaWrapper setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public CriteriaWrapper setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    private void checkSession() {
        if (session == null) {
            throw new IllegalArgumentException("Session is null!");
        }

        if (clazz == null) {
            throw new IllegalArgumentException("Clazz is null!");
        }
    }

    public int rowCount() {
        checkSession();

        Criteria criteria = session.createCriteria(clazz);
        criteriaTools.addToCriteria(criteria, true);
        criteria.setReadOnly(readOnly);
        criteria.setCacheable(cacheable);
        criteria.setProjection(Projections.rowCount());
        Long count = (Long) criteria.uniqueResult();
        return count.intValue();
    }

    public Object result(boolean isUnique) {
        checkSession();

        Criteria criteria = session.createCriteria(clazz);
        criteriaTools.addToCriteria(criteria, false);
        criteria.setReadOnly(readOnly);
        criteria.setCacheable(cacheable);

        if (firstResult != -1 && maxResult != -1) {
            criteria.setFirstResult(firstResult);
            criteria.setMaxResults(maxResult);
        }

        if (isUnique) {
            return criteria.uniqueResult();
        } else {
            return criteria.list();
        }
    }

    public Object uniqueResult() {
        return result(true);
    }

    public List listResult() {
        List list = (List) result(false);
        if (list == null) {
            return Lists.newArrayList();
        } else {
            return list;
        }
    }
}
