package com.valor.vod.common.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.valor.vod.common.http.resp.AccountBaseInfoResp;

import common.config.tools.config.ConfigTools3;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Service
public class UserHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(UserHttpClient.class);

    @Autowired private RestTemplate vmsRestTemplate;

    public AccountBaseInfoResp queryAccountBaseInfoByDid(String did) throws Exception {
        // need check isHot
        return queryAccountBaseInfoByLoginId(did, 5, 0);
    }

    public AccountBaseInfoResp queryAccountBaseInfoByLoginId(
            String loginId, int userType, int appId) throws Exception {
        String url = ConfigTools3.getString("http.user.queryAccountBaseInfoByLoginId");
        if (StringUtils.isEmpty(url) || StringUtils.isEmpty(url)) {
            return null;
        }
        String fullUrl = url + "?loginId=" + loginId + "&userType=" + userType + "&appId=" + appId;
        logger.info("queryAccountBaseInfoByLoginId(),fullUrl:{}", fullUrl);
        HttpHeaders requestHeaders = new HttpHeaders();
        Map<String, String> params = new HashMap<>();
        HttpEntity httpEntity = new HttpEntity(params, requestHeaders);

        ResponseEntity<String> postForEntity = null;
        try {
            postForEntity = vmsRestTemplate.postForEntity(fullUrl, httpEntity, String.class);
        } catch (HttpClientErrorException e1) {
            logger.error(
                    "queryAccountBaseInfoByLoginId(),invoke exception.{}",
                    e1.getResponseBodyAsString());
            throw e1;
        }

        logger.info(
                "queryAccountBaseInfoByLoginId(),response:{},{}",
                postForEntity.getStatusCodeValue(),
                postForEntity.getBody());

        if (postForEntity.getStatusCodeValue() == 200) {
            JSONObject userJson =
                    JSONObject.parseObject(postForEntity.getBody()).getJSONObject("result");
            AccountBaseInfoResp account = JSON.toJavaObject(userJson, AccountBaseInfoResp.class);
            logger.info(
                    "queryAccountBaseInfoByLoginId(),return success,accountId:{},accountType:{}",
                    account.getAccountId(),
                    account.getAccountType());
            return account;
        } else if (postForEntity.getStatusCodeValue() == 555) {
            JSONObject userJson = JSONObject.parseObject(postForEntity.getBody());
            int retCode = userJson.getIntValue("retCode");
            int errCode = userJson.getIntValue("errCode");
            if (retCode == 1003 && errCode == 20001) {
                logger.info(
                        "queryAccountBaseInfoByLoginId(),return notfound,retCode:{},errCode:{}",
                        retCode,
                        errCode);
                return null;
            } else {
                logger.error(
                        "queryAccountBaseInfoByLoginId(),response is {},not 200",
                        postForEntity.getStatusCodeValue());
                throw new Exception("response is " + postForEntity.getStatusCodeValue());
            }
        } else {
            logger.error(
                    "queryAccountBaseInfoByLoginId(),response is {},not 200",
                    postForEntity.getStatusCodeValue());
            throw new Exception("response is " + postForEntity.getStatusCodeValue());
        }
    }
}
