package com.valor.vod.common.model.token;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.metric.client.MetricAgent;
import com.valor.vod.api.common.encrypt.AESUtils;
import com.valor.vod.api.model.constant.response.HttpCode2;
import com.valor.vod.common.web.request.BaseRequestArgs;

import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.Objects;

// import com.live.db.model.ddo.user.UserAccount;

/** Created by Frank.Huang on 2017/1/21. */
public class ServiceTokenTools {
    private static final Logger logger = LoggerFactory.getLogger(ServiceTokenTools.class);
    private static final String ST_AES_KEY = "mJIO8-VzwO9crd2LE34weg";

    // original -> padLong(md5(sha1(v)))
    public static String serviceHash(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return "";
        }

        String sha1Hash = Hashing.sha1().hashString(value, Charsets.UTF_8).toString();
        return Hashing.md5().hashString(sha1Hash, Charsets.UTF_8).padToLong() + "";
    }

    // original -> sha1(v)
    public static String serviceHash2(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return "";
        }

        return Hashing.sha1().hashString(value, Charsets.UTF_8).toString();
    }

    // original -> padLong(md5())
    public static String serviceHash3(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return "";
        }

        return Hashing.md5().hashString(value, Charsets.UTF_8).padToLong() + "";
    }

    @Deprecated
    public static String getServiceToken(String did, String serviceCode) {
        ServiceTokenV2 serviceToken = new ServiceTokenV2();
        serviceToken.setVersion(ServiceTokenV2.VER_20170121);
        serviceToken.setDid(did);
        serviceToken.setServiceCode(formatActivateCode(serviceCode));

        return encodeServiceToken(serviceToken);
    }

    public static String getServiceToken(String did, String serviceCode, String echoStr) {
        ServiceTokenV2 serviceToken = new ServiceTokenV2();
        serviceToken.setVersion(ServiceTokenV2.VER_20170731);
        serviceToken.setDid(did);
        serviceToken.setServiceCode(serviceHash(formatActivateCode(serviceCode)));
        if (Strings.isNullOrEmpty(echoStr)) {
            echoStr = String.valueOf(serviceToken.getVersion());
        }
        serviceToken.setEchoStr(serviceHash(echoStr));

        return encodeServiceToken(serviceToken);
    }

    public static String formatActivateCode(String code) {
        // 格式话激活码格式,统一已P开头
        if (Strings.isNullOrEmpty(code)) {
            return code;
        }

        if (code.startsWith("P")) {
            return code;
        } else {
            return "P" + code;
        }
    }

    public static String encodeServiceToken(ServiceTokenV2 serviceToken) {
        if (serviceToken == null) {
            return "";
        }

        try {
            return AESUtils.encrypt(serviceToken.toSerializeString(), ST_AES_KEY);
        } catch (Exception e) {
            logger.error("encodeServiceToken exception:{}", e);
        }
        return "";
    }

    public static ServiceTokenV2 decodeServiceToken(String stStr) {
        try {
            String decodeStStr = AESUtils.decrypt(stStr, ST_AES_KEY);
            return ServiceTokenV2.valueOf(decodeStStr);
        } catch (Exception e) {
            logger.error("decodeServiceToken exception:{}", e);
            return null;
        }
    }

    public static void checkServiceToken(BaseRequestArgs apiRequest) throws ApiException {
        checkServiceToken(
                apiRequest.getDid(),
                apiRequest.getClientIp(),
                apiRequest.getSt(),
                apiRequest.getLang(),
                "",
                apiRequest.getProtocol());
    }

    public static void checkServiceToken(
            String did,
            String clientIp,
            String st,
            String lang,
            String activateCode,
            String protocol)
            throws ApiException {
        ServiceTokenV2 serviceToken = null;
        int ret = checkServiceToken2(did, clientIp, st, activateCode, serviceToken);
        if (ret != 0) {
            throw new ApiException(HttpCode2.RET_BIZ_ERR, ret, "Invalid token.", did);
        }
    }

    public static int checkServiceToken2(
            String did,
            String clientIp,
            String st,
            String activateCode,
            ServiceTokenV2 serviceToken) {
        if (Strings.isNullOrEmpty(st)) {
            logger.warn("ST is empty");
            return HttpCode2.ERR_BIZ_EMPTY_SERVICE_TOKEN;
        }

        if (null == serviceToken) {
            serviceToken = ServiceTokenTools.decodeServiceToken(st);
        }

        if (serviceToken == null) {
            logger.error("Invalid Service Token(decode error):{}", st);
            //  report2Metric(did, clientIp, serviceToken, HttpCode2.ERR_ST_DECRYPT_FAILED);
            return HttpCode2.ERR_ST_DECRYPT_FAILED;
        }

        if (!did.equalsIgnoreCase(serviceToken.getDid())) {
            logger.error("Invalid Service Token did[{}-{}]", did, serviceToken.getDid());
            //  report2Metric(did, clientIp, serviceToken, HttpCode2.ERR_ST_DID_ILLEGAL);
            return HttpCode2.ERR_ST_DID_ILLEGAL;
        }

        if (ConfigTools3.getAsBoolean("mfc.st.activate.code.check.enable", false)) {
            // 校验act code(如果有就校验,没有就不校验)
            if (!Strings.isNullOrEmpty(activateCode)) {
                String activate = "";
                if (serviceToken.getVersion() == ServiceTokenV2.VER_20170121) {
                    String activateCodeStr = serviceToken.getServiceCode();
                    activate = serviceHash(formatActivateCode(activateCodeStr));
                } else if (serviceToken.getVersion() == ServiceTokenV2.VER_20170731) {
                    activate = serviceToken.getServiceCode();
                }

                String dbActivateCode = serviceHash3(activateCode);
                if (!dbActivateCode.contentEquals(activate)) {
                    logger.error("Invalid Service Token(Wrong activation code) did[{}] ", did);
                    //     report2Metric(did, clientIp, serviceToken, HttpCode2.
                    // ERR_ST_ACT_CODE_INVALID);
                    return HttpCode2.ERR_ST_ACT_CODE_INVALID;
                }
            }
        }

        return 0;
    }

    // report st check error
    private static void report2Metric(
            String did, String clientIp, ServiceTokenV2 serviceToken, int ret) {
        Map<String, String> tags = null;
        Map<String, Object> fields = null;
        try {
            tags =
                    new ImmutableMap.Builder<String, String>()
                            .put("m_client_ip", Strings.nullToEmpty(clientIp))
                            .put("t_ret", Strings.nullToEmpty(ret + ""))
                            .build();

            String didInSt =
                    Objects.isNull(serviceToken) ? "-" : Strings.nullToEmpty(serviceToken.getDid());
            fields = ImmutableMap.of("f_did", did, "f_did_in_st", didInSt);
            MetricAgent.postEvent("mfc_service_token", tags, fields);
        } catch (Exception e) {
            // 上报失败
            logger.error(
                    "[ST] Report to metric exception:tags[{}] fields[{}] ex[{}]", tags, fields, e);
        }
    }
}
