package com.valor.vod.common.model.token;

import static com.google.common.base.Joiner.on;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.valor.vod.api.common.client.IStringSerializable;
import com.valor.vod.api.model.constant.response.HttpCode2;

import common.base.tools.exception.ApiException;

import java.io.UnsupportedEncodingException;
import java.util.List;

/**
 * @ClassName: ServiceTokenV2 @Auther: admin @Date: 3/7/2019 @Version 1.0 @Description:
 */
public class ServiceTokenV2 implements IStringSerializable {

    public static final int VER_20170121 = 20170121;
    public static final int VER_20170731 = 20170731;
    private int version = VER_20170731;
    private String did = "";
    private String serviceCode = "";
    private Long random = System.currentTimeMillis();
    private String echoStr = "8dcd2c7f7d47ae01";
    private Long createTime = System.currentTimeMillis();

    public static ServiceTokenV2 valueOf(String str) throws ApiException {
        if (Strings.isNullOrEmpty(str)) {
            throw new ApiException(
                    HttpCode2.RET_BIZ_ERR,
                    HttpCode2.ERR_BIZ_INVALID_SERVICE_TOKEN,
                    "Invalid service token");
        }

        List<String> valueList = Splitter.on("#!").splitToList(str);
        if (valueList.size() == 0) {
            throw new ApiException(
                    HttpCode2.RET_BIZ_ERR,
                    HttpCode2.ERR_BIZ_INVALID_SERVICE_TOKEN,
                    "Invalid service token(format,error");
        }

        ServiceTokenV2 serviceToken = new ServiceTokenV2();

        serviceToken.setVersion(Integer.valueOf(valueList.get(0)));
        serviceToken.setDid(valueList.get(1));
        serviceToken.setServiceCode(valueList.get(2));
        serviceToken.setRandom(Long.valueOf(valueList.get(3)));
        serviceToken.setEchoStr(valueList.get(4));
        if (serviceToken.getVersion() == VER_20170731) {
            serviceToken.setCreateTime(Long.valueOf(valueList.get(5)));
        }
        return serviceToken;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getServiceCode() {
        return serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public String getEchoStr() {
        return echoStr;
    }

    public void setEchoStr(String echoStr) {
        this.echoStr = echoStr;
    }

    public Long getRandom() {
        return random;
    }

    public void setRandom(Long random) {
        this.random = random;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toSerializeString() {
        return on("#!").join(version, did, serviceCode, random, echoStr, createTime);
    }

    @Override
    public byte[] toSerializeBytes() {
        try {
            return toSerializeString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}
