package com.valor.vod.common.tools.cache;

import com.valor.vod.api.common.ListTool;
import com.valor.vod.common.cache.redis.RedisCache;
import com.valor.vod.common.tools.type.CollectionUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;

public class RedisTools {
    private static final Logger logger = LoggerFactory.getLogger(RedisTools.class);

    public static <K, V> Map<K, V> gets(
            RedisCache util,
            String prefix,
            Set<K> keys,
            long expiredTime,
            Function<Set<K>, Map<K, V>> getsByDb) {
        Map<K, V> resultMap = new HashMap<>();
        if (keys == null) {
            return resultMap;
        }
        Set<String> keySet = new HashSet<>();
        Map<String, K> keyIdMap = new HashMap<>();
        for (K k : keys) {
            String key = prefix + k;
            keySet.add(key);
            keyIdMap.put(key, k);
        }

        Set<String> dbKeySet = new HashSet<>();

        Map<String, List<V>> vMap = util.mGet(keySet);
        if (vMap != null) {
            for (Map.Entry<String, List<V>> e : vMap.entrySet()) {
                if (CollectionUtils.isNullOrEmpty(e.getValue())) {
                    dbKeySet.add(e.getKey());
                } else {
                    K k = keyIdMap.get(e.getKey());
                    V v = null;
                    // 用数组保存的对象
                    if (e.getValue().size() != 0) {
                        v = e.getValue().get(0);
                    }
                    resultMap.put(k, v);
                }
            }
        } else {
            dbKeySet.addAll(keySet);
        }

        if (dbKeySet.size() == 0) {
            return resultMap;
        }
        logger.info("gets(),{} keys is not matched in redis,get from db.", dbKeySet.size());
        // 没有了,或异常了，重新加载
        try {
            Set<K> dbIdSet = new HashSet<>();
            for (String key : dbKeySet) {
                dbIdSet.add(keyIdMap.get(key));
            }

            Map<K, V> dbIdMap = getsByDb.apply(dbIdSet);
            //            List<V> accts = userCloudDao.getCloudAccts(dbCidSet);
            //            if (accts == null){
            //                accts = new ArrayList<>();
            //            }
            //            Map<K,V> dbCidMap = new HashMap<>();
            //            for (int i=0;i<accts.size();i++){
            //                dbCidMap.put(accts.get(i).getCid(),accts.get(i));
            //            }
            Map<String, List<V>> dbVMap = new HashMap<>();
            // long expiredTime =
            // ConfigTools3.getLong("mfc.cloudapi.refreshCloudAcct.periodSeconds", 3600L);

            for (String key : dbKeySet) {
                K id = keyIdMap.get(key);
                if (dbIdMap.containsKey(id)) {
                    V v = dbIdMap.get(id);
                    dbVMap.put(key, ListTool.toList(v));
                    resultMap.put(id, v);
                } else {
                    dbVMap.put(key, new ArrayList<>());
                    resultMap.put(id, null);
                }
            }
            util.pipSetEx(dbVMap, expiredTime);
            return resultMap;
        } catch (Exception ex) {
            logger.error("gets(),exception.", ex);
            //return new HashMap<>();
            throw ex;
        }
    }
}
