package com.valor.vod.common.tools.distributed;

/**
 * @author Tom Tang
 * @date 2022/8/30
 */
public interface DistributedLock {

    /**
     * Acquires the lock only if it is free at the time of invocation.
     *
     * <p>Acquires the lock if it is available and returns immediately
     * with the value {@code true}.
     * If the lock is not available then this method will return
     * immediately with the value {@code false}.
     *
     * @return {@code true} if the lock was acquired and
     * {@code false} otherwise
     */
    boolean tryLock();

    /**
     * Releases the lock.
     */
    void unlock();
}
