package com.valor.vod.common.tools.http;

import com.google.common.base.Strings;
import com.valor.vod.api.common.encrypt.AESUtils;

import common.config.tools.config.ConfigTools3;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** Created by Frank.Huang on 2016/7/13. */
public class ASKeyConfig {
    private static final Logger logger = LoggerFactory.getLogger(ASKeyConfig.class);

    public static String getAsKey() {
        String key = ConfigTools3.getString("mfc_vms_as_var1", "");
        if (Strings.isNullOrEmpty(key)) {
            return "";
        }

        String key2 = getASKey2();
        if (Strings.isNullOrEmpty(key2)) {
            return "";
        }

        try {
            return AESUtils.decrypt(key, key2);
        } catch (Exception e) {
            logger.error("{}", e);
            return "";
        }
    }

    public static int getTokenExpire() {
        return ConfigTools3.getInt("mfc_vms_as_var2", -1);
    }

    public static String getASKey2() {
        return ConfigTools3.getString("mfc_vms_as_var3", "");
    }
}
