package com.valor.vod.common.tools.http;

import com.google.common.base.Strings;
import com.valor.vod.api.common.encrypt.AESUtils;

import common.config.tools.config.ConfigTools3;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** Created by Frank.Huang on 2016/7/13. */
public class AppKeyConfig {
    private static final Logger logger = LoggerFactory.getLogger(AppKeyConfig.class);

    public static String getAppkey() {
        String key = ConfigTools3.getString("mfc_vms_app_var1", "");
        if (Strings.isNullOrEmpty(key)) {
            return "";
        }

        String key2 = ConfigTools3.getString("mfc_vms_app_var2", "");
        if (Strings.isNullOrEmpty(key2)) {
            return "";
        }

        try {
            return AESUtils.decrypt(key, key2);
        } catch (Exception e) {
            logger.error("{}", e);
            return "";
        }
    }
}
