package com.valor.vod.common.tools.log;

import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.web.request.IRequestArgs;
import com.valor.vod.common.web.response.IResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;

/** File : Description : Author : Frank Created : 2016/1/1 22:13 */
public class LogUtil {
    private static final Logger logger = LoggerFactory.getLogger(LogUtil.class);

    public static void logReq(HttpServletRequest request, IRequestArgs args) {
        logger.info(
                "[REQ] [HOST]:[{}] [QUERY STRING]:[{}?{}] ARGS[{}]",
                HttpTools.getRemoteHost(request),
                getRequestURL(request),
                getQueryString(request),
                args == null ? "-" : args.toString());
    }

    public static void logRsp(String host, String apiName, String args, String response) {
        logger.info(
                "[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]",
                apiName,
                response,
                args == null ? "" : args.toString());
    }

    public static void logRsp(
            String host, String apiName, IRequestArgs args, ResponseStatus response) {
        logger.info(
                "[RSP] [HOST]:[{}] [API]:[{}] resp[{}] req:[{}]", host, apiName, response, args);
    }

    public static void logErrRsp(
            String host, String apiName, IRequestArgs args, IResponse response) {
        logger.info(
                "[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]",
                host,
                apiName,
                response,
                args == null ? "" : args.toString());
    }

    public static void logErrRsp(
            String host, String apiName, IRequestArgs args, ResponseStatus response) {
        logger.info(
                "[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]",
                host,
                apiName,
                response,
                args == null ? "" : args.toString());
    }

    private static String getQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    private static String getRequestURL(HttpServletRequest request) {
        return request.getRequestURI();
    }
}
