package com.valor.vod.common.tools.stat;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 统计Bean方法执行时长注解
 *
 * <p>只能用于对Bean方法的被调用
 *
 * @author Tom Tang
 * @date 2022/1/12
 * @since 3.0.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface BeanMethodStatistics {
    String key() default "";
}
