package com.valor.vod.common.tools.type;

import com.google.common.collect.Multimap;

import java.util.*;
import java.util.function.Function;

/**
 * @author Frank.Huang
 * @date 2023-03-16
 */
public class CollectionUtils {
    /**
     * 检查集合是不是null or empty
     *
     * @param collection
     * @return
     */
    public static boolean isNullOrEmpty(final Collection collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public static boolean isNullOrEmpty(final Map map) {
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    public static boolean isNullOrEmpty(final Multimap map) {
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    public static boolean contains(final Collection<?> coll, final Object o) {
        return !isNullOrEmpty(coll) && coll.contains(o);
    }

    public static boolean isContains(final Set set1, final Set set2) {
        if (isNullOrEmpty(set1) || isNullOrEmpty(set2)) {
            return false;
        }

        for (Object e : set1) {
            if (set2.contains(e)) {
                return true;
            }
        }

        return false;
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return map.get(key);
    }

    /**
     * replace
     *
     * @param list
     * @param func
     * @param <T>
     */
    public static <T> void replaceAll(List<T> list, Function<T, T> func) {
        ListIterator<T> it = list.listIterator();
        while (it.hasNext()) {
            it.set(func.apply(it.next()));
        }
    }

    public static <T> List<T> union(Collection<T> c1, Collection<T> c2) {
        if (isNullOrEmpty(c1) && isNullOrEmpty(c2)) {
            return new ArrayList<>();
        } else if (isNullOrEmpty(c1)) {
            return new ArrayList<>(c2);
        } else if (isNullOrEmpty(c2)) {
            return new ArrayList<>(c1);
        } else {
            ArrayList<T> res = new ArrayList<>(c1.size() + c2.size());
            res.addAll(c1);
            res.addAll(c2);
            return res;
        }
    }
}
