package com.valor.vod.common.tools.type;

import java.util.Set;

/**
 * Set工具类
 *
 * @author Tom Tang
 * @date 2021/8/10
 * @since 3.0.0
 */
public class SetTools {

    /**
     * 判断两个Set是否存在交集
     *
     * @param s1 set1
     * @param s2 set2
     * @return 是否存在交集
     */
    public static boolean intersected(Set<?> s1, Set<?> s2) {
        if (s1 == null || s2 == null) {
            return false;
        }

        return s1.size() < s2.size()
                ? s1.stream().anyMatch(s2::contains)
                : s2.stream().anyMatch(s1::contains);
    }
}
