package com.valor.vod.common.web.request;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.HashMap;
import java.util.Map;

/** File : valormotorserver:${FILE_NAME} Description : Author : Frank Created : 2015/9/13 */
public abstract class AbstractRequestArgs extends CryptRequestArgs implements IRequestArgs {

    protected boolean argsValid = true;
    protected Map<String, String> verifyMsg = new HashMap<>();

    @JsonIgnore
    public Map<String, String> getVerifyMsg() {
        return verifyMsg;
    }

    public void setVerifyMsg(Map<String, String> verifyMsg) {
        this.verifyMsg = verifyMsg;
    }

    public void setVerifyMsg(String args, String msg) {
        verifyMsg.put(args, msg);
    }

    @JsonIgnore
    @Override
    public boolean isArgsValid() {
        return argsValid;
    }

    @JsonIgnore
    @Override
    public String getVerifyResult() {
        if (!verifyMsg.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            verifyMsg.forEach(
                    (k, v) -> {
                        sb.append(String.format("\"%s\":\"%s\",", k, v));
                    });
            sb.append("}");

            return sb.toString();
        }

        return "";
    }

    @Override
    public boolean checkArgs(String name, Object arg, IArgsValueChecker valueChecker) {
        boolean localArgValid = true;
        if (arg == null) {
            setVerifyMsg(name, ArgsVerifyMsg.ARG_NOT_ALLOWED_NULL);
            argsValid = false;
            localArgValid = false;
        }

        if (arg instanceof String) {
            if (((String) arg).isEmpty()) {
                setVerifyMsg(name, ArgsVerifyMsg.ARG_NOT_ALLOWED_EMPTY);
                argsValid = false;
                localArgValid = false;
            }
        }

        if (valueChecker != null) {
            if (!valueChecker.isValueVaild(arg)) {
                setVerifyMsg(name, ArgsVerifyMsg.ARG_INVALID_VALUE);
                argsValid = false;
                localArgValid = false;
            }
        }

        return localArgValid;
    }

    @Override
    public boolean checkArgs(String name, Object arg) {
        return this.checkArgs(name, arg, null);
    }
}
