package com.valor.vod.common.web.request;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * yamj3
 *
 * @author Frank
 * @since 2015/9/2 23:45
 */
public class PagingArgs extends BaseRequestArgs implements IPagingArgs {
    private static int MAX_PAGE_SIZE = 300;

    /**
     * 分页ID
     *
     * @mock 1
     */
    private int pageId = 1;
    /**
     * 分页大小
     *
     * @mock 10
     */
    private int pageSize = 10;
    /**
     * 排序参数
     *
     * @mock {key:value{ans|desc};}
     */
    private String sort = "";
    /**
     * 过滤参数
     *
     * @mock {key:value;key:value1,value2:in;}
     */
    private String filter = "";

    @Override
    public int getPageId() {
        return pageId;
    }

    @Override
    public void setPageId(int pageId) {
        if (pageId <= 1) {
            this.pageId = 1;
        } else {
            this.pageId = pageId;
        }
    }

    @Override
    public int getPageSize() {
        return pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        if (pageSize > MAX_PAGE_SIZE) {
            argsValid = false;
            setVerifyMsg("PageSize", "Page size large than MAX(" + MAX_PAGE_SIZE + ").");
        } else if (pageSize > 0) {
            this.pageSize = pageSize;
        } else {
            this.pageSize = 10;
        }
    }

    @Override
    public String getSort() {
        return sort;
    }

    @Override
    public void setSort(String sort) {
        this.sort = sort;
    }

    @Override
    @JsonIgnore
    public int getPageStart() {
        return ((pageId - 1) * pageSize);
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}
