package com.valor.vod.common.web.tools;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.valor.vod.api.common.encrypt.AESUtils;

import common.base.tools.type.NumberTools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Set;

/** Created by Frank.Huang on 2016/10/22. */
public class ArgTools {
    public static final String ARG_AES_KEY = "wqlnDJADUFnNRUn0fj2CXA";
    public static final String ARG_AES_KEY2 = "c3pW333jKHafoMvqPI1bYQ";
    public static final String ARG_SEPARATOR = ",";
    private static final Logger logger = LoggerFactory.getLogger(ArgTools.class);

    public static String decryptArg(String arg) {
        try {
            return AESUtils.decrypt(arg, ARG_AES_KEY);
        } catch (Exception e) {
            logger.error("Decode arg exception:{}", e);
            return "";
        }
    }

    public static String encryptArg(String arg) {
        try {
            return AESUtils.encrypt(arg, ARG_AES_KEY);
        } catch (Exception e) {
            logger.error("Encrypt arg exception:{}", e);
            return "";
        }
    }

    public static String decryptArg2(String arg) {
        try {
            return AESUtils.decrypt(arg, ARG_AES_KEY2);
        } catch (Exception e) {
            logger.error("Decode arg exception:{}", e);
            return "";
        }
    }

    public static String encryptArg2(String arg) {
        try {
            return AESUtils.encrypt(arg, ARG_AES_KEY2);
        } catch (Exception e) {
            logger.error("Encrypt arg exception:{}", e);
            return "";
        }
    }

    public static Set<Long> getArgAsLongSet(String arg) {
        Set<Long> args = Sets.newLinkedHashSet();
        if (Strings.isNullOrEmpty(arg)) {
            return args;
        }

        List<String> argList =
                Splitter.on(ARG_SEPARATOR).omitEmptyStrings().trimResults().splitToList(arg);
        for (String e : argList) {
            Long v = (Long) NumberTools.toNumeric(Long.class, e);
            if (v != null) {
                args.add(v);
            }
        }

        return args;
    }

    public static List<Long> getArgAsLongList(String arg) {
        List<Long> args = Lists.newArrayList();
        if (Strings.isNullOrEmpty(arg)) {
            return args;
        }

        List<String> argList =
                Splitter.on(ARG_SEPARATOR).omitEmptyStrings().trimResults().splitToList(arg);
        for (String e : argList) {
            Long v = (Long) NumberTools.toNumeric(Long.class, e);
            if (v != null) {
                args.add(v);
            }
        }

        return args;
    }

    public static Set<String> getArgAsStringSet(String arg) {
        Set<String> args = Sets.newLinkedHashSet();
        if (Strings.isNullOrEmpty(arg)) {
            return args;
        }

        List<String> argList =
                Splitter.on(ARG_SEPARATOR).omitEmptyStrings().trimResults().splitToList(arg);
        return Sets.newHashSet(argList);
    }
}
