/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.cache.redis;

import com.alibaba.fastjson.JSON;
import com.valor.vod.common.cache.redis.ProtobufRedisTemplate;
import com.valor.vod.common.condition.RedisClusterConnectionConditon;
import com.valor.vod.common.condition.RedisSingleConnectionCondition;
import common.config.tools.config.ConfigTools3;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import io.lettuce.core.resource.Delay;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleCacheErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class VodRedisConfig
extends CachingConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(VodRedisConfig.class);
    int dbIndex = ConfigTools3.getInt((String)"spring.redis.database", (Integer)0);
    String host = ConfigTools3.getString((String)"spring.redis.host", (String)"");
    int port = ConfigTools3.getInt((String)"spring.redis.port", (Integer)0);
    String password = ConfigTools3.getString((String)"spring.redis.password", (String)"");
    long connectTimeout = ConfigTools3.getLong((String)"spring.redis.connectTimeout", (Long)100L);
    long fixedTimeout = ConfigTools3.getLong((String)"spring.redis.fixedTimeout", (Long)5L);

    @Conditional(value={RedisSingleConnectionCondition.class})
    @Bean(name={"vodRedisConnectionFactory"})
    @Primary
    public RedisConnectionFactory getRedisConnectionFactory() {
        return this.createRedisConnectionFactory(this.dbIndex, this.host, this.port, this.password, this.connectTimeout, this.fixedTimeout);
    }

    @Conditional(value={RedisClusterConnectionConditon.class})
    @Bean(name={"vodRedisConnectionFactory"})
    @Primary
    public RedisConnectionFactory getClusterRedisConnectionFactory() {
        return this.createRedisClusterConnectionFactory(this.host, this.port, this.password, this.connectTimeout, this.fixedTimeout);
    }

    public LettuceConnectionFactory createRedisClusterConnectionFactory(String host, int port, String password, Long connectTimeout, Long fixedTimeout) {
        RedisClusterNode node = new RedisClusterNode(host, port);
        RedisClusterConfiguration config = new RedisClusterConfiguration();
        config.addClusterNode((RedisNode)node);
        config.setPassword(password);
        return new LettuceConnectionFactory(config, (LettuceClientConfiguration)this.configPool(connectTimeout, fixedTimeout, true));
    }

    private LettucePoolingClientConfiguration configPool(Long connectTimeout, Long fixedTimeout, boolean cluster) {
        ClientOptions clientOptions;
        DefaultClientResources resources = DefaultClientResources.builder().reconnectDelay(Delay.fullJitter((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(5L), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).build();
        if (cluster) {
            ClusterTopologyRefreshOptions topologyRefreshOptions = ClusterTopologyRefreshOptions.builder().enableAllAdaptiveRefreshTriggers().enableAdaptiveRefreshTrigger(new ClusterTopologyRefreshOptions.RefreshTrigger[0]).enablePeriodicRefresh(Duration.ofSeconds(10L)).build();
            clientOptions = ClusterClientOptions.builder().autoReconnect(true).socketOptions(SocketOptions.builder().connectTimeout(Duration.ofMillis(connectTimeout)).build()).timeoutOptions(TimeoutOptions.builder().fixedTimeout(Duration.ofSeconds(fixedTimeout)).build()).topologyRefreshOptions(topologyRefreshOptions).build();
        } else {
            clientOptions = ClientOptions.builder().autoReconnect(true).socketOptions(SocketOptions.builder().connectTimeout(Duration.ofMillis(connectTimeout)).build()).timeoutOptions(TimeoutOptions.builder().fixedTimeout(Duration.ofSeconds(fixedTimeout)).build()).build();
        }
        return LettucePoolingClientConfiguration.builder().poolConfig(this.getPoolConfig()).clientResources((ClientResources)resources).clientOptions(clientOptions).readFrom(ReadFrom.ANY).build();
    }

    @Bean
    public CacheErrorHandler errorHandler() {
        return new RedisCacheErrorHandler();
    }

    private LettuceConnectionFactory createRedisConnectionFactory(int dbIndex, String host, int port, String password, Long connectTimeout, Long fixedTimeout) {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setDatabase(dbIndex);
        redisStandaloneConfiguration.setHostName(host);
        redisStandaloneConfiguration.setPort(port);
        redisStandaloneConfiguration.setPassword(password);
        return new LettuceConnectionFactory(redisStandaloneConfiguration, (LettuceClientConfiguration)this.configPool(connectTimeout, fixedTimeout, false));
    }

    public GenericObjectPoolConfig getPoolConfig() {
        int redisPoolMaxIdle = ConfigTools3.getInt((String)"spring.redis.pool.max-idle", (Integer)8);
        int redisPoolMinIdle = ConfigTools3.getInt((String)"spring.redis.pool.min-idle", (Integer)0);
        int redisPoolMaxActive = ConfigTools3.getInt((String)"spring.redis.pool.max-active", (Integer)8);
        int redisPoolMaxWait = ConfigTools3.getInt((String)"spring.redis.pool.max-wait", (Integer)-1);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(redisPoolMaxIdle);
        poolConfig.setMinIdle(redisPoolMinIdle);
        poolConfig.setMaxTotal(redisPoolMaxActive);
        poolConfig.setMaxWaitMillis((long)redisPoolMaxWait);
        poolConfig.setTestOnBorrow(true);
        return poolConfig;
    }

    @Bean
    public RedisCacheManager cacheManager(@Qualifier(value="vodRedisConnectionFactory") RedisConnectionFactory redisConnectionFactory) {
        RedisCacheWriter cacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory);
        Long expiredTime = ConfigTools3.getLong((String)"mfc.redis.cache.expire.time", (Long)7200L);
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(expiredTime)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer()));
        return new RedisCacheManager(cacheWriter, config);
    }

    @Bean(name={"cacheKeyGenerator"})
    public KeyGenerator keyGenerator() {
        return (target, method, params) -> {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getName()).append(".");
            sb.append(method.getName()).append(".");
            for (Object obj : params) {
                sb.append(JSON.toJSONString((Object)obj).hashCode());
            }
            return sb.toString();
        };
    }

    @Bean(name={"redisTemplate"})
    @Primary
    public RedisTemplate<String, Object> redisTemplate(@Qualifier(value="vodRedisConnectionFactory") RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        GenericJackson2JsonRedisSerializer redisSerializer = new GenericJackson2JsonRedisSerializer();
        redisTemplate.setValueSerializer((RedisSerializer)redisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)redisSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    public StringRedisTemplate stringRedisTemplate(@Qualifier(value="vodRedisConnectionFactory") RedisConnectionFactory redisConnectionFactory) {
        return new StringRedisTemplate(redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(type={"protobufRedisTemplate"})
    public ProtobufRedisTemplate protobufRedisTemplate(@Qualifier(value="vodRedisConnectionFactory") RedisConnectionFactory redisConnectionFactory) {
        ProtobufRedisTemplate protobufRedisTemplate = new ProtobufRedisTemplate();
        protobufRedisTemplate.setConnectionFactory(redisConnectionFactory);
        return protobufRedisTemplate;
    }

    private static class RedisCacheErrorHandler
    extends SimpleCacheErrorHandler {
        private RedisCacheErrorHandler() {
        }

        public void handleCacheGetError(RuntimeException exception, Cache cache, Object key) {
            log.error("handleCacheGetError key = {}, value = {}", key, (Object)cache);
            log.error("cache get error", (Throwable)exception);
        }

        public void handleCachePutError(RuntimeException exception, Cache cache, Object key, Object value) {
            log.error("handleCachePutError key = {}, value = {}", key, (Object)cache);
            log.error("cache put error", (Throwable)exception);
        }

        public void handleCacheEvictError(RuntimeException exception, Cache cache, Object key) {
            log.error("handleCacheEvictError key = {}, value = {}", key, (Object)cache);
            log.error("cache evict error", (Throwable)exception);
        }

        public void handleCacheClearError(RuntimeException exception, Cache cache) {
            log.error("handleCacheClearError value = {}", (Object)cache);
            log.error("cache clear error", (Throwable)exception);
        }
    }
}

