/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.database.tool.CriteriaWrapper;

import com.google.common.collect.Lists;
import com.valor.vod.common.database.tool.CriteriaWrapper.CriteriaTools;
import com.valor.vod.common.tools.type.CollectionUtils;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

public class CriteriaWrapper {
    private CriteriaTools criteriaTools = CriteriaTools.create();
    private Session session = null;
    private Class clazz = null;
    private int firstResult = -1;
    private int maxResult = -1;
    private boolean cacheable = false;
    private boolean readOnly = false;

    public static CriteriaWrapper create(Session session, Class clazz) {
        CriteriaWrapper instance = new CriteriaWrapper();
        instance.session = session;
        instance.clazz = clazz;
        return instance;
    }

    public CriteriaWrapper add(Criterion criterion) {
        this.criteriaTools.add(criterion);
        return this;
    }

    public CriteriaWrapper add(Set<Criterion> criterions) {
        if (!CollectionUtils.isNullOrEmpty(criterions)) {
            criterions.forEach(e -> this.criteriaTools.add((Criterion)e));
        }
        return this;
    }

    public CriteriaWrapper addOrder(Order order) {
        this.criteriaTools.addOrder(order);
        return this;
    }

    public CriteriaWrapper addOrder(Set<Order> orders) {
        if (!CollectionUtils.isNullOrEmpty(orders)) {
            orders.forEach(e -> this.criteriaTools.addOrder((Order)e));
        }
        return this;
    }

    public CriteriaWrapper setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public CriteriaWrapper setMaxResult(int maxResult) {
        this.maxResult = maxResult;
        return this;
    }

    public CriteriaWrapper setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public CriteriaWrapper setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    private void checkSession() {
        if (this.session == null) {
            throw new IllegalArgumentException("Session is null!");
        }
        if (this.clazz == null) {
            throw new IllegalArgumentException("Clazz is null!");
        }
    }

    public int rowCount() {
        this.checkSession();
        Criteria criteria = this.session.createCriteria(this.clazz);
        this.criteriaTools.addToCriteria(criteria, true);
        criteria.setReadOnly(this.readOnly);
        criteria.setCacheable(this.cacheable);
        criteria.setProjection(Projections.rowCount());
        Long count = (Long)criteria.uniqueResult();
        return count.intValue();
    }

    public Object result(boolean isUnique) {
        this.checkSession();
        Criteria criteria = this.session.createCriteria(this.clazz);
        this.criteriaTools.addToCriteria(criteria, false);
        criteria.setReadOnly(this.readOnly);
        criteria.setCacheable(this.cacheable);
        if (this.firstResult != -1 && this.maxResult != -1) {
            criteria.setFirstResult(this.firstResult);
            criteria.setMaxResults(this.maxResult);
        }
        if (isUnique) {
            return criteria.uniqueResult();
        }
        return criteria.list();
    }

    public Object uniqueResult() {
        return this.result(true);
    }

    public List listResult() {
        List list = (List)this.result(false);
        if (list == null) {
            return Lists.newArrayList();
        }
        return list;
    }
}

