/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.model.token;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.valor.vod.api.common.client.IStringSerializable;
import com.valor.vod.api.exception.ApiException;
import com.valor.vod.common.tools.type.CollectionUtils;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ServiceToken
implements IStringSerializable {
    private static final int VER_20170121 = 20170121;
    private int version = 20170121;
    private String did = "";
    private String serviceCode = "";
    private Long random = System.currentTimeMillis();
    private String echoStr = "";

    public static ServiceToken valueOf(String str) throws ApiException {
        if (Strings.isNullOrEmpty((String)str)) {
            throw new ApiException(9, 902, "Invalid service token");
        }
        List valueList = Splitter.on((String)"#!").splitToList((CharSequence)str);
        if (CollectionUtils.isNullOrEmpty(valueList)) {
            throw new ApiException(9, 902, "Invalid service token(format,error");
        }
        ServiceToken serviceToken = new ServiceToken();
        serviceToken.setVersion(Integer.valueOf((String)valueList.get(0)));
        serviceToken.setDid((String)valueList.get(1));
        serviceToken.setServiceCode((String)valueList.get(2));
        serviceToken.setRandom(Long.valueOf((String)valueList.get(3)));
        serviceToken.setEchoStr((String)valueList.get(4));
        return serviceToken;
    }

    public String getDid() {
        return this.did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public String getEchoStr() {
        return this.echoStr;
    }

    public void setEchoStr(String echoStr) {
        this.echoStr = echoStr;
    }

    public Long getRandom() {
        return this.random;
    }

    public void setRandom(Long random) {
        this.random = random;
    }

    public String toSerializeString() {
        return Joiner.on((String)"#!").join((Object)this.version, (Object)this.did, new Object[]{this.serviceCode, this.random, this.echoStr});
    }

    public byte[] toSerializeBytes() {
        try {
            return this.toSerializeString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

