/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.model.token;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.metric.client.MetricAgent;
import com.valor.vod.api.common.encrypt.AESUtils;
import com.valor.vod.common.model.token.ServiceTokenV2;
import com.valor.vod.common.web.request.BaseRequestArgs;
import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTokenTools {
    private static final Logger logger = LoggerFactory.getLogger(ServiceTokenTools.class);
    private static final String ST_AES_KEY = "mJIO8-VzwO9crd2LE34weg";

    public static String serviceHash(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return "";
        }
        String sha1Hash = Hashing.sha1().hashString((CharSequence)value, Charsets.UTF_8).toString();
        return Hashing.md5().hashString((CharSequence)sha1Hash, Charsets.UTF_8).padToLong() + "";
    }

    public static String serviceHash2(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return "";
        }
        return Hashing.sha1().hashString((CharSequence)value, Charsets.UTF_8).toString();
    }

    public static String serviceHash3(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return "";
        }
        return Hashing.md5().hashString((CharSequence)value, Charsets.UTF_8).padToLong() + "";
    }

    @Deprecated
    public static String getServiceToken(String did, String serviceCode) {
        ServiceTokenV2 serviceToken = new ServiceTokenV2();
        serviceToken.setVersion(20170121);
        serviceToken.setDid(did);
        serviceToken.setServiceCode(ServiceTokenTools.formatActivateCode(serviceCode));
        return ServiceTokenTools.encodeServiceToken(serviceToken);
    }

    public static String getServiceToken(String did, String serviceCode, String echoStr) {
        ServiceTokenV2 serviceToken = new ServiceTokenV2();
        serviceToken.setVersion(20170731);
        serviceToken.setDid(did);
        serviceToken.setServiceCode(ServiceTokenTools.serviceHash(ServiceTokenTools.formatActivateCode(serviceCode)));
        if (Strings.isNullOrEmpty((String)echoStr)) {
            echoStr = String.valueOf(serviceToken.getVersion());
        }
        serviceToken.setEchoStr(ServiceTokenTools.serviceHash(echoStr));
        return ServiceTokenTools.encodeServiceToken(serviceToken);
    }

    public static String formatActivateCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            return code;
        }
        if (code.startsWith("P")) {
            return code;
        }
        return "P" + code;
    }

    public static String encodeServiceToken(ServiceTokenV2 serviceToken) {
        if (serviceToken == null) {
            return "";
        }
        try {
            return AESUtils.encrypt((String)serviceToken.toSerializeString(), (String)ST_AES_KEY);
        }
        catch (Exception e) {
            logger.error("encodeServiceToken exception:{}", (Throwable)e);
            return "";
        }
    }

    public static ServiceTokenV2 decodeServiceToken(String stStr) {
        try {
            String decodeStStr = AESUtils.decrypt((String)stStr, (String)ST_AES_KEY);
            return ServiceTokenV2.valueOf(decodeStStr);
        }
        catch (Exception e) {
            logger.error("decodeServiceToken exception:{}", (Throwable)e);
            return null;
        }
    }

    public static void checkServiceToken(BaseRequestArgs apiRequest) throws ApiException {
        ServiceTokenTools.checkServiceToken(apiRequest.getDid(), apiRequest.getClientIp(), apiRequest.getSt(), apiRequest.getLang(), "", apiRequest.getProtocol());
    }

    public static void checkServiceToken(String did, String clientIp, String st, String lang, String activateCode, String protocol) throws ApiException {
        ServiceTokenV2 serviceToken = null;
        int ret = ServiceTokenTools.checkServiceToken2(did, clientIp, st, activateCode, serviceToken);
        if (ret != 0) {
            throw new ApiException(9, ret, "Invalid token.", did);
        }
    }

    public static int checkServiceToken2(String did, String clientIp, String st, String activateCode, ServiceTokenV2 serviceToken) {
        if (Strings.isNullOrEmpty((String)st)) {
            logger.warn("ST is empty");
            return 903;
        }
        if (null == serviceToken) {
            serviceToken = ServiceTokenTools.decodeServiceToken(st);
        }
        if (serviceToken == null) {
            logger.error("Invalid Service Token(decode error):{}", (Object)st);
            return 905;
        }
        if (!did.equalsIgnoreCase(serviceToken.getDid())) {
            logger.error("Invalid Service Token did[{}-{}]", (Object)did, (Object)serviceToken.getDid());
            return 907;
        }
        if (ConfigTools3.getAsBoolean((String)"mfc.st.activate.code.check.enable", (boolean)false) && !Strings.isNullOrEmpty((String)activateCode)) {
            String activate = "";
            if (serviceToken.getVersion() == 20170121) {
                String activateCodeStr = serviceToken.getServiceCode();
                activate = ServiceTokenTools.serviceHash(ServiceTokenTools.formatActivateCode(activateCodeStr));
            } else if (serviceToken.getVersion() == 20170731) {
                activate = serviceToken.getServiceCode();
            }
            String dbActivateCode = ServiceTokenTools.serviceHash3(activateCode);
            if (!dbActivateCode.contentEquals(activate)) {
                logger.error("Invalid Service Token(Wrong activation code) did[{}] ", (Object)did);
                return 908;
            }
        }
        return 0;
    }

    private static void report2Metric(String did, String clientIp, ServiceTokenV2 serviceToken, int ret) {
        ImmutableMap tags = null;
        ImmutableMap fields = null;
        try {
            tags = new ImmutableMap.Builder().put((Object)"m_client_ip", (Object)Strings.nullToEmpty((String)clientIp)).put((Object)"t_ret", (Object)Strings.nullToEmpty((String)(ret + ""))).build();
            String didInSt = Objects.isNull(serviceToken) ? "-" : Strings.nullToEmpty((String)serviceToken.getDid());
            fields = ImmutableMap.of((Object)"f_did", (Object)did, (Object)"f_did_in_st", (Object)didInSt);
            MetricAgent.postEvent((String)"mfc_service_token", (Map)tags, (Map)fields);
        }
        catch (Exception e) {
            logger.error("[ST] Report to metric exception:tags[{}] fields[{}] ex[{}]", new Object[]{tags, fields, e});
        }
    }
}

