/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.cache;

import com.valor.vod.api.common.ListTool;
import com.valor.vod.common.cache.redis.RedisCache;
import com.valor.vod.common.tools.type.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisTools {
    private static final Logger logger = LoggerFactory.getLogger(RedisTools.class);

    public static <K, V> Map<K, V> gets(RedisCache util, String prefix, Set<K> keys, long expiredTime, Function<Set<K>, Map<K, V>> getsByDb) {
        HashMap resultMap = new HashMap();
        if (keys == null) {
            return resultMap;
        }
        HashSet<String> keySet = new HashSet<String>();
        HashMap<Object, K> keyIdMap = new HashMap<Object, K>();
        for (K k : keys) {
            String key = prefix + k;
            keySet.add(key);
            keyIdMap.put(key, k);
        }
        HashSet<Object> dbKeySet = new HashSet<Object>();
        Map vMap = util.mGet(keySet);
        if (vMap != null) {
            for (Map.Entry entry : vMap.entrySet()) {
                if (CollectionUtils.isNullOrEmpty((Collection)entry.getValue())) {
                    dbKeySet.add(entry.getKey());
                    continue;
                }
                Object v = keyIdMap.get(entry.getKey());
                Object v2 = null;
                if (((List)entry.getValue()).size() != 0) {
                    v2 = ((List)entry.getValue()).get(0);
                }
                resultMap.put(v, v2);
            }
        } else {
            dbKeySet.addAll(keySet);
        }
        if (dbKeySet.size() == 0) {
            return resultMap;
        }
        logger.info("gets(),{} keys is not matched in redis,get from db.", (Object)dbKeySet.size());
        try {
            HashSet dbIdSet = new HashSet();
            for (String string : dbKeySet) {
                dbIdSet.add(keyIdMap.get(string));
            }
            Map<K, V> map = getsByDb.apply(dbIdSet);
            HashMap<String, List> hashMap = new HashMap<String, List>();
            for (String string : dbKeySet) {
                Object id = keyIdMap.get(string);
                if (map.containsKey(id)) {
                    V v = map.get(id);
                    hashMap.put(string, ListTool.toList((Object[])new Object[]{v}));
                    resultMap.put(id, v);
                    continue;
                }
                hashMap.put(string, new ArrayList());
                resultMap.put(id, null);
            }
            util.pipSetEx(hashMap, expiredTime);
            return resultMap;
        }
        catch (Exception ex) {
            logger.error("gets(),exception.", (Throwable)ex);
            throw ex;
        }
    }
}

