/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.log;

import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.web.request.IRequestArgs;
import com.valor.vod.common.web.response.IResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static final Logger logger = LoggerFactory.getLogger(LogUtil.class);

    public static void logReq(HttpServletRequest request, IRequestArgs args) {
        logger.info("[REQ] [HOST]:[{}] [QUERY STRING]:[{}?{}] ARGS[{}]", new Object[]{HttpTools.getRemoteHost(request), LogUtil.getRequestURL(request), LogUtil.getQueryString(request), args == null ? "-" : args.toString()});
    }

    public static void logRsp(String host, String apiName, String args, String response) {
        logger.info("[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]", new Object[]{apiName, response, args == null ? "" : args.toString()});
    }

    public static void logRsp(String host, String apiName, IRequestArgs args, ResponseStatus response) {
        logger.info("[RSP] [HOST]:[{}] [API]:[{}] resp[{}] req:[{}]", new Object[]{host, apiName, response, args});
    }

    public static void logErrRsp(String host, String apiName, IRequestArgs args, IResponse response) {
        logger.info("[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]", new Object[]{host, apiName, response, args == null ? "" : args.toString()});
    }

    public static void logErrRsp(String host, String apiName, IRequestArgs args, ResponseStatus response) {
        logger.info("[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]", new Object[]{host, apiName, response, args == null ? "" : args.toString()});
    }

    private static String getQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    private static String getRequestURL(HttpServletRequest request) {
        return request.getRequestURI();
    }
}

