/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.stat;

import com.valor.vod.common.tools.stat.BeanMethodStatistics;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class BeanMethodStatisticsAspect {
    @Around(value="@annotation(annotation)")
    public Object statRuntime(ProceedingJoinPoint pjp, BeanMethodStatistics annotation) throws Throwable {
        String key = annotation.key();
        if (StringUtils.isEmpty((CharSequence)key)) {
            key = this.getDefaultKey(pjp);
        }
        Object ret = pjp.proceed();
        return ret;
    }

    private String getDefaultKey(ProceedingJoinPoint pjp) {
        Object target = pjp.getTarget();
        String className = target == null ? "" : target.getClass().getSimpleName();
        return className + '.' + pjp.getSignature().getName();
    }
}

