/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.type;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class CollectionUtils {
    public static boolean isNullOrEmpty(Collection collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map map) {
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    public static boolean isNullOrEmpty(Multimap map) {
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    public static boolean contains(Collection<?> coll, Object o) {
        return !CollectionUtils.isNullOrEmpty(coll) && coll.contains(o);
    }

    public static boolean isContains(Set set1, Set set2) {
        if (CollectionUtils.isNullOrEmpty(set1) || CollectionUtils.isNullOrEmpty(set2)) {
            return false;
        }
        for (Object e : set1) {
            if (!set2.contains(e)) continue;
            return true;
        }
        return false;
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return map.get(key);
    }

    public static <T> void replaceAll(List<T> list, Function<T, T> func) {
        ListIterator<T> it = list.listIterator();
        while (it.hasNext()) {
            it.set(func.apply(it.next()));
        }
    }

    public static <T> List<T> union(Collection<T> c1, Collection<T> c2) {
        if (CollectionUtils.isNullOrEmpty(c1) && CollectionUtils.isNullOrEmpty(c2)) {
            return new ArrayList();
        }
        if (CollectionUtils.isNullOrEmpty(c1)) {
            return new ArrayList<T>(c2);
        }
        if (CollectionUtils.isNullOrEmpty(c2)) {
            return new ArrayList<T>(c1);
        }
        ArrayList<T> res = new ArrayList<T>(c1.size() + c2.size());
        res.addAll(c1);
        res.addAll(c2);
        return res;
    }
}

