package com.valor.vod.es.api.model.service.cloud;

import com.valor.vod.es.api.model.service.base.AbstractDoc;
import org.elasticsearch.common.Strings;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * Created by Frank.Huang on 2017/3/6.
 */
public class MediaCloud extends AbstractDoc {
    protected Long cid;
    protected String site = "";  //站点
    protected String acct = "";  //账户
    protected String acctAlias = "";  //账户别名
    protected String resName = "";  //资源名称
    protected String resId = "";  //资源id
    protected String resPath = "";  //资源路径
    protected String decodeKey = "";  //解码key
    protected Long resLength = 0L;   //资源长度
    protected String format = "";   //格式 3D/VR etc.
    protected String quality = "";  ////质量 320p/480p/720p/1080p/4k
    protected String extra = "";//附加信息, 例如 特别版本，献礼版本等
    protected Long audioLanguage; //音轨
    protected Set<String> audioLanguageName=new LinkedHashSet(); //音轨名
    protected Long createTS; //创建时间
    protected Long updateTS; //修改时间
    protected Integer season;
    protected Integer episode;
    protected Integer mediaType;
    protected Integer status;
    protected String resHandle;

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getAcct() {
        return acct;
    }

    public void setAcct(String acct) {
        this.acct = acct;
    }

    public String getAcctAlias() {
        return acctAlias;
    }

    public void setAcctAlias(String acctAlias) {
        this.acctAlias = acctAlias;
    }

    public String getResName() {
        return resName;
    }

    public void setResName(String resName) {
        this.resName = resName;
    }

    public String getResId() {
        return resId;
    }

    public void setResId(String resId) {
        this.resId = resId;
    }

    public String getResPath() {
        return resPath;
    }

    public void setResPath(String resPath) {
        this.resPath = resPath;
    }

    public Long getResLength() {
        return resLength;
    }

    public void setResLength(Long resLength) {
        this.resLength = resLength;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getQuality() {
        return quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public Long getAudioLanguage() {
        return audioLanguage;
    }

    public void setAudioLanguage(Long audioLanguage) {
        this.audioLanguage = audioLanguage;
    }

    public Set<String> getAudioLanguageName() {
        return audioLanguageName;
    }

    public void setAudioLanguageName(Set<String> audioLanguageName) {
        this.audioLanguageName = audioLanguageName;
    }

    public Long getCreateTS() {
        return createTS;
    }

    public void setCreateTS(Long createTS) {
        this.createTS = createTS;
    }

    public Long getUpdateTS() {
        return updateTS;
    }

    public void setUpdateTS(Long updateTS) {
        this.updateTS = updateTS;
    }

    public Integer getMediaType() {
        return mediaType;
    }

    public void setMediaType(Integer mediaType) {
        this.mediaType = mediaType;
    }

    public String getDecodeKey() {
        return decodeKey;
    }

    public void setDecodeKey(String decodeKey) {
        this.decodeKey = decodeKey;
    }

    public Integer getSeason() {
        return season;
    }

    public void setSeason(Integer season) {
        this.season = season;
    }

    public Integer getEpisode() {
        return episode;
    }

    public void setEpisode(Integer episode) {
        this.episode = episode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getResHandle() {
        return resHandle;
    }

    public void setResHandle(String resHandle) {
        this.resHandle = resHandle;
    }

    @Override
    public String getDocumentId() {
        if (!Strings.isNullOrEmpty(documentId)) {
            return documentId;
        }
        return makeDocumentId(cid, resId, season, episode);
    }
}
