package com.valor.vod.es.api.model.service.media;

import com.valor.vod.es.api.model.service.base.AbstractLocaleDoc;
import common.base.tools.encrypt.MD5Tools;
import org.elasticsearch.common.Strings;

import java.util.Date;

/**
 * Created by Frank.Huang on 2017/3/6.
 */
public class MediaSynopsis extends AbstractLocaleDoc {

    private Integer mediaType;
    private Integer year;
    private String source;
    private String title;
    private String text;
    private Date createTime;

    public Integer getMediaType() {
        return mediaType;
    }

    public void setMediaType(Integer mediaType) {
        this.mediaType = mediaType;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getDocumentId() {
        if (!Strings.isNullOrEmpty(documentId)){
            return documentId;
        }
        return makeDocumentId(id, language, MD5Tools.hmacMd5(this.text));
    }

}
