package com.valor.vod.es.api.model.service.search;

import com.valor.vod.es.api.model.service.base.AbstractPrintable;

/**
 * Created by Frank.Huang on 2017/3/16.
 */
public class ESOrder extends AbstractPrintable {
    private boolean ascending;
    private String source;
    private String nestedPath;

    public static ESOrder asc(String source,String nestedPath){
        return new ESOrder(source,true,nestedPath);
    }
    public static ESOrder asc(String source){
        return asc(source,null);
    }

    public static ESOrder desc(String source,String nestedPath){
        return new ESOrder(source,false,nestedPath);
    }
    public static ESOrder desc(String source){
        return desc(source,null);
    }

    protected ESOrder(String source,boolean ascending) {
        this(source,ascending,null);
    }
    public ESOrder(String source,boolean ascending,String nestedPath) {
        this.ascending = ascending;
        this.source = source;
        this.nestedPath = nestedPath;
    }

    public boolean isAscending() {
        return ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getNestedPath() {
        return nestedPath;
    }

    public void setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
    }
}
